/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.transformation

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventSpec
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.stext.stext.StextFactory
import com.yakindu.sct.model.stext.stext.SubmachineReferenceExpression
import org.eclipse.emf.ecore.util.EcoreUtil
import com.google.inject.Singleton

/**
 * @author Axel Terfloth added 'active' extension
 */
 @Singleton
class StextExtensions {

	val expfactory = ExpressionsFactory::eINSTANCE

	val factory = StextFactory::eINSTANCE

	@Inject protected extension StatemachineTypes

	def Expression or(Expression left, Expression right) {
		val or = expfactory.createLogicalOrExpression
		or.leftOperand = left
		or.rightOperand = right
		or
	}

	def Expression and(Expression left, Expression right) {
		val and = expfactory.createLogicalAndExpression
		and.leftOperand = left
		and.rightOperand = right
		and
	}

	def Expression parenthesis(Expression exp) {
		val p = expfactory.createParenthesizedExpression
		p.expression = exp
		p
	}

	def Expression active(RegularState state) {
		val active = factory.createActiveStateReferenceExpression
		active.value = state
		active
	}

	def operationCall(SubmachineReferenceExpression subRef, String opName) {
		expfactory.createFeatureCall => [
			owner = EcoreUtil.copy(subRef.submachine)
			feature = subRef.submachine.operation(opName)
		]
	}

	def localReaction(EventSpec triggerEvent, Expression action) {
		factory.createLocalReaction => [
			trigger = expfactory.createReactionTrigger => [
				triggers += triggerEvent
			]
			effect = expfactory.createReactionEffect => [
				actions += action
			]
		]
	}

	private def dispatch Operation operation(Expression prop, String opName) {
		throw new IllegalArgumentException("Could not find operation '" + opName + "'.")
	}

	private def dispatch Operation operation(FeatureCall fc, String name) {
		fc.feature.operation(name)
	}

	private def dispatch Operation operation(ElementReferenceExpression ref, String name) {
		ref.reference.operation(name)
	}

	private def dispatch Operation operation(Property prop, String opName) {
		prop.statemachineType.allFeatures.filter(Operation).filter[name == opName].head
	}

}
