/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sgen.util

import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart

/** 
 * Extension class with functions related to sgen model handling.
 */
class SgenExtensions {

	/** 
	 * returns a statechart instance directly or indirectly referenced from a
	 * GeneratorEntry.
	 */
	def static Statechart getStatechart(GeneratorEntry entry) {
		if (entry === null) {
			return null;
		}
		val elementRef = entry.getElementRef();
		if (elementRef instanceof Statechart) {
			return elementRef;
		} else {
			// search reference to statechart in ElementRef, e.g. an SCTUnit test
			return elementRef.eCrossReferences.filter(Statechart).head 
		}
	}

}
