/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.definitionsection;

import com.google.inject.Injector;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.xtext.utils.jface.viewers.FilteringMenuManager;
import com.yakindu.base.xtext.utils.jface.viewers.XtextStyledTextSelectionProvider;
import com.yakindu.base.xtext.utils.jface.viewers.context.XtextFakeResourceContext;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.naming.IdentifierConverter;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.definitionsection.ContextScopeHandler;
import com.yakindu.sct.ui.editor.definitionsection.StyledTextSelectionListener;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningEditor;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sct.ui.editor.propertysheets.ValidatingEMFDatabindingContext;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.XMLMemento;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class StatechartDefinitionSection
extends Composite
implements IPersistableEditor,
IPersistableElement {
    protected static final String SHOW_SECTION_TOOLTIP = "Show definition section";
    protected static final String HIDE_SECTION_TOOLTIP = "Hide definition section";
    protected static final int SASH_WIDTH = 5;
    protected static final int BORDERWIDTH = 2;
    protected static final int MAXIMIZED_CONTROL_INDEX = 1;
    protected static final String MEM_EXPANDED = "DefinitionSectionIsExpanded";
    protected static final String MEM_FIRST_WEIGHT = "FirstSashWeight";
    protected static final String MEM_SECOND_WEIGHT = "SecondSashWeight";
    protected static final int[] MIN_SIZE = new int[]{13, 21};
    protected static final int[] DEFAULT_WEIGHTS = new int[]{2, 10};
    protected int[] previousWidths = DEFAULT_WEIGHTS;
    protected static Cursor CURSOR_HAND = new Cursor((Device)Display.getCurrent(), 21);
    private boolean sectionExpanded = true;
    private MouseListener mouseListener;
    private ResizeListener resizeListener;
    private ModifyListener nameModificationListener;
    private Label switchControl;
    private Composite labelComposite;
    private CollapsedBorder collapsedBorder;
    private InlineIcon inlineIcon;
    private EmbeddedEditor embeddedEditor;
    private XtextResource xtextResource;
    private SashForm sash;
    private DiagramPartitioningEditor editorPart;
    private static IMemento memento;
    private ValidatingEMFDatabindingContext context;
    private DefinitionSectionSynchronizer synchronizer;
    private Text nameLabel;

    public StatechartDefinitionSection(Composite parent, int style, DiagramPartitioningEditor editorPart) {
        super(parent, style);
        this.sash = (SashForm)parent;
        this.editorPart = editorPart;
        this.switchControl = this.createSwitchControl();
        this.labelComposite = this.createDefinitionSectionComponents();
        this.embeddedEditor = this.createSpecificationEditor();
        this.registerResizeListener();
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this);
        this.initSynchronizer();
    }

    protected Label createSwitchControl() {
        Label switchControl = new Label((Composite)this, 8);
        switchControl.setToolTipText(this.sectionExpanded ? HIDE_SECTION_TOOLTIP : SHOW_SECTION_TOOLTIP);
        switchControl.setImage(this.sectionExpanded ? StatechartImages.COLLAPSE.image() : StatechartImages.EXPAND.image());
        switchControl.setCursor(CURSOR_HAND);
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(-1, -1).hint(MIN_SIZE[0], MIN_SIZE[1]).applyTo((Control)switchControl);
        this.mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                StatechartDefinitionSection.this.toggleExpandState();
            }
        };
        switchControl.addMouseListener(this.mouseListener);
        return switchControl;
    }

    protected Composite createDefinitionSectionComponents() {
        Composite labelComposite = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(labelComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)labelComposite);
        this.createNameLabel(labelComposite);
        this.createInlineIcon(labelComposite);
        this.createSeparator(this);
        this.createCollapsedBorder(this);
        return labelComposite;
    }

    protected void initSynchronizer() {
        this.synchronizer = new DefinitionSectionSynchronizer();
        this.getContextObject().eAdapters().add((Object)this.synchronizer);
    }

    protected void removeSynchronizer() {
        this.getContextObject().eAdapters().remove((Object)this.synchronizer);
    }

    protected void createNameLabel(Composite labelComposite) {
        this.nameLabel = new Text(labelComposite, 4);
        GridDataFactory.fillDefaults().indent(5, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)this.nameLabel);
        Optional<String> name = this.getStatechartName();
        if (name.isPresent()) {
            this.nameLabel.setText(name.get());
        }
        this.nameLabel.setEditable(this.isStatechart());
        this.nameLabel.setBackground(ColorConstants.white);
        this.nameModificationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Optional<Statechart> sct = StatechartDefinitionSection.this.getStatechart();
                if (sct.isPresent()) {
                    if (Objects.equals(sct.get().getName(), StatechartDefinitionSection.this.nameLabel.getText())) {
                        return;
                    }
                    StatechartDefinitionSection.this.getSash().setRedraw(false);
                    TransactionalEditingDomain domain = StatechartDefinitionSection.this.getTransactionalEditingDomain();
                    SetCommand command = new SetCommand((EditingDomain)domain, (EObject)sct.get(), (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME, (Object)StatechartDefinitionSection.this.nameLabel.getText());
                    domain.getCommandStack().execute((Command)command);
                    StatechartDefinitionSection.this.refresh(StatechartDefinitionSection.this.nameLabel.getParent());
                    StatechartDefinitionSection.this.getSash().setRedraw(true);
                }
            }
        };
        this.nameLabel.addModifyListener(this.nameModificationListener);
    }

    protected Optional<String> getStatechartName() {
        Statechart statechart = (Statechart)EcoreUtil2.getContainerOfType((EObject)this.getContextObject(), Statechart.class);
        if (statechart == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(statechart.getName());
    }

    protected void createInlineIcon(Composite labelComposite) {
        this.inlineIcon = new InlineIcon(labelComposite, 4);
    }

    protected boolean isStatechart() {
        return this.getContextObject() instanceof Statechart;
    }

    protected Optional<Statechart> getStatechart() {
        return Optional.ofNullable((Statechart)EcoreUtil2.getContainerOfType((EObject)this.getContextObject(), Statechart.class));
    }

    protected void createSeparator(Composite definitionSection) {
        Label separator = new Label(definitionSection, 258);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)separator);
    }

    protected void createCollapsedBorder(Composite definitionSection) {
        this.collapsedBorder = new CollapsedBorder(definitionSection, 0);
        this.refresh(definitionSection);
    }

    protected void refresh(Composite comp) {
        comp.layout(false, true);
        comp.redraw();
        comp.update();
    }

    protected EmbeddedEditor createSpecificationEditor() {
        ContextScopeHandler.defineContext("org.eclipse.xtext.ui.embeddedTextEditorScope", "org.eclipse.ui.textEditorScope");
        EmbeddedEditor embeddedEditor = this.createEmbeddedEditor();
        embeddedEditor.createPartialEditor();
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(embeddedEditor.getViewer().getControl());
        StyledText text = embeddedEditor.getViewer().getTextWidget();
        text.setAlwaysShowScrollBars(false);
        text.setSelection(0);
        text.setKeyBinding(SWT.MOD1 | 0x61, 262209);
        this.initXtextSelectionProvider(text);
        this.initContextMenu((Control)text);
        text.addModifyListener(event -> this.editorPart.firePropertyChange(257));
        text.setEnabled(this.editorPart.isEditable());
        return embeddedEditor;
    }

    protected EmbeddedEditor createEmbeddedEditor() {
        Injector embeddedEditorInjector = this.getEmbeddedStatechartSpecificationInjector();
        EmbeddedEditorFactory instance = (EmbeddedEditorFactory)embeddedEditorInjector.getInstance(EmbeddedEditorFactory.class);
        IEditedResourceProvider provider = this.getXtextResourceProvider(embeddedEditorInjector);
        return instance.newEditor(provider).showErrorAndWarningAnnotations().withParent((Composite)this);
    }

    protected Injector getEmbeddedStatechartSpecificationInjector() {
        IDomain domain = DomainRegistry.getDomain((EObject)this.getContextObject());
        return domain.getInjector("com.yakindu.sct.editor", new String[]{Statechart.class.getName()});
    }

    protected IEditedResourceProvider getXtextResourceProvider(final Injector injector) {
        return new IEditedResourceProvider(){

            public XtextResource createResource() {
                IProject activeProject = WorkspaceSynchronizer.getFile((Resource)StatechartDefinitionSection.this.getContextObject().eResource()).getProject();
                XtextFakeResourceContext resource = new XtextFakeResourceContext(injector, activeProject);
                StatechartDefinitionSection.this.xtextResource = resource.getFakeResource();
                StatechartDefinitionSection.this.xtextResource.eAdapters().add((Object)new ContextElementAdapter(StatechartDefinitionSection.this.getContextObject()));
                return StatechartDefinitionSection.this.xtextResource;
            }
        };
    }

    protected void initXtextSelectionProvider(StyledText widget) {
        try {
            XtextStyledTextSelectionProvider provider = new XtextStyledTextSelectionProvider(widget, this.xtextResource);
            StyledTextSelectionListener styledTextSelectionListener = new StyledTextSelectionListener(this.editorPart.getSite(), widget, (ISelectionProvider)provider);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void activate() {
        this.initBinding(this.embeddedEditor.getViewer().getTextWidget());
        this.getSash().setMaximizedControl(null);
    }

    protected void deactivate() {
        this.getSash().setMaximizedControl(this.getSash().getChildren()[1]);
        if (this.context != null) {
            this.context.dispose();
        }
    }

    protected void initBinding(StyledText text) {
        IEMFEditValueProperty modelProperty = EMFEditProperties.value((EditingDomain)this.getTransactionalEditingDomain(), (EStructuralFeature)SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION);
        ISWTObservableValue uiProperty = WidgetProperties.text((int[])new int[]{16}).observe((Widget)text);
        IObservableValue modelPropertyObservable = modelProperty.observe((Object)this.getContextObject());
        this.context = new ValidatingEMFDatabindingContext((EObject)this.editorPart.getAdapter(EObject.class), this.editorPart.getSite().getShell());
        this.context.bindValue((IObservableValue)uiProperty, modelPropertyObservable, null, null);
    }

    protected void initContextMenu(Control control) {
        FilteringMenuManager menuManager = new FilteringMenuManager();
        Menu contextMenu = menuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        IWorkbenchPartSite site = this.editorPart.getSite();
        if (site != null) {
            site.registerContextMenu("com.yakindu.base.xtext.utils.jface.viewers.StyledTextXtextAdapterContextMenu", (MenuManager)menuManager, site.getSelectionProvider());
        }
    }

    protected void registerResizeListener() {
        this.resizeListener = new ResizeListener();
        this.getSash().addControlListener((ControlListener)this.resizeListener);
        this.embeddedEditor.getViewer().getTextWidget().addControlListener((ControlListener)this.resizeListener);
    }

    protected TransactionalEditingDomain getTransactionalEditingDomain() {
        return (TransactionalEditingDomain)this.editorPart.getAdapter(TransactionalEditingDomain.class);
    }

    public EObject getContextObject() {
        return (EObject)this.editorPart.getAdapter(EObject.class);
    }

    protected Diagram getDiagram() {
        return (Diagram)this.editorPart.getAdapter(Diagram.class);
    }

    protected void toggleDefinitionSection() {
        this.toggleInlineStyle();
        this.updateStyle();
        this.refreshEditorContents();
    }

    private void toggleInlineStyle() {
        AddCommand command;
        TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
        Diagram diagram = this.getDiagram();
        BooleanValueStyle inlineStyle = DiagramPartitioningUtil.getInlineDefinitionSectionStyle((View)diagram);
        if (inlineStyle == null) {
            inlineStyle = DiagramPartitioningUtil.createInlineDefinitionSectionStyle();
            command = new AddCommand((EditingDomain)domain, (EObject)this.getDiagram(), (EStructuralFeature)NotationPackage.Literals.VIEW__STYLES, (Object)inlineStyle);
            domain.getCommandStack().execute((Command)command);
        }
        command = new SetCommand((EditingDomain)domain, (EObject)inlineStyle, (EStructuralFeature)NotationPackage.Literals.BOOLEAN_VALUE_STYLE__BOOLEAN_VALUE, (Object)(!inlineStyle.isBooleanValue() ? 1 : 0));
        domain.getCommandStack().execute((Command)command);
    }

    public void updateStyle() {
        if (this.isInlined()) {
            this.deactivate();
        } else {
            this.activate();
        }
    }

    protected boolean isInlined() {
        BooleanValueStyle style = DiagramPartitioningUtil.getInlineDefinitionSectionStyle((View)this.getDiagram());
        return style != null ? style.isBooleanValue() : true;
    }

    protected void collapseDefinitionSection() {
        int parentWidth = this.getSash().getBounds().width;
        int switchControlWidth = this.getSwitchControlWidth();
        int[] sashWidths = this.getCollapsedSashWidths(parentWidth, switchControlWidth);
        this.layoutDefinitionSection(0, sashWidths, false, 1);
    }

    protected void expandDefinitionSection() {
        this.layoutDefinitionSection(5, this.previousWidths, true, 2);
    }

    protected int getSwitchControlWidth() {
        return this.switchControl.getBounds().width + 2;
    }

    protected int[] getCollapsedSashWidths(int parentWidth, int switchControlWidth) {
        int diff = parentWidth - switchControlWidth;
        if (diff < 0) {
            return DEFAULT_WEIGHTS;
        }
        return new int[]{switchControlWidth, diff % 2 != 0 ? diff - 3 : diff};
    }

    protected void layoutDefinitionSection(int sashWidth, int[] weights, boolean visible, int hSpan) {
        this.getSash().setRedraw(false);
        this.getSash().setSashWidth(sashWidth);
        this.getSash().setWeights(weights);
        this.embeddedEditor.getViewer().getControl().setVisible(visible);
        this.labelComposite.setVisible(visible);
        if (visible) {
            this.refreshSwitchControl(HIDE_SECTION_TOOLTIP, StatechartImages.COLLAPSE.image());
        } else {
            this.refreshSwitchControl(SHOW_SECTION_TOOLTIP, StatechartImages.EXPAND.image());
        }
        this.layoutCollapsedBorder(hSpan);
        this.layoutEmbeddedEditor(hSpan);
        this.refresh((Composite)this.getSash());
        this.getSash().setRedraw(true);
    }

    protected void toggleExpandState() {
        this.getSash().setRedraw(false);
        boolean bl = this.sectionExpanded = !this.sectionExpanded;
        if (this.sectionExpanded) {
            this.expandDefinitionSection();
        } else {
            this.collapseDefinitionSection();
        }
        this.getSash().setRedraw(true);
    }

    protected void layoutEmbeddedEditor(int hSpan) {
        ((GridData)this.embeddedEditor.getViewer().getControl().getLayoutData()).horizontalSpan = hSpan;
    }

    protected void layoutCollapsedBorder(int hSpan) {
        ((GridData)this.collapsedBorder.getLayoutData()).horizontalSpan = hSpan;
    }

    protected void refreshSwitchControl(String tooltipText, Image image) {
        this.switchControl.setToolTipText(tooltipText);
        this.switchControl.setImage(image);
    }

    public void dispose() {
        this.saveState(memento);
        this.removeSynchronizer();
        this.disposeEmbeddedEditor();
        super.dispose();
    }

    protected void disposeEmbeddedEditor() {
        if (this.mouseListener != null && this.switchControl != null && !this.switchControl.isDisposed()) {
            this.switchControl.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
            this.switchControl.dispose();
            this.switchControl = null;
        }
        if (this.inlineIcon != null && !this.inlineIcon.isDisposed()) {
            this.inlineIcon.dispose();
        }
        if (this.collapsedBorder != null && !this.collapsedBorder.isDisposed()) {
            this.collapsedBorder.dispose();
        }
        if (this.embeddedEditor != null) {
            this.embeddedEditor.getDocument().getValidationJob().cancel();
            StyledText embeddedEditorWidget = this.embeddedEditor.getViewer().getTextWidget();
            if (embeddedEditorWidget != null && !embeddedEditorWidget.isDisposed()) {
                if (this.resizeListener != null) {
                    embeddedEditorWidget.removeControlListener((ControlListener)this.resizeListener);
                    this.getSash().removeControlListener((ControlListener)this.resizeListener);
                    this.resizeListener = null;
                }
                embeddedEditorWidget.dispose();
                embeddedEditorWidget = null;
                this.embeddedEditor = null;
            }
        }
        this.nameModificationListener = null;
    }

    public void validateEmbeddedEditorContext() {
        if (this.embeddedEditor == null || this.embeddedEditor.getDocument() == null || this.embeddedEditor.getDocument().getValidationJob() == null) {
            return;
        }
        this.embeddedEditor.getDocument().getValidationJob().schedule();
    }

    public SashForm getSash() {
        return this.sash;
    }

    protected void refreshEditorContents() {
        ((DiagramEditPart)this.editorPart.getAdapter(DiagramEditPart.class)).getChildren().forEach(part -> {
            if (part instanceof EditPart) {
                ((EditPart)part).refresh();
            }
        });
    }

    public String getFactoryId() {
        return this.editorPart.getEditorInput().getPersistable().getFactoryId();
    }

    public void restoreSashWidths() {
        if (memento == null) {
            this.saveState(memento);
        }
        this.restoreState(memento);
    }

    public void saveState(IMemento memento) {
        try {
            if (memento == null) {
                memento = XMLMemento.createWriteRoot((String)this.getFactoryId());
            }
            this.setMementoProperties(memento);
            this.saveCurrentMemento(memento);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void restoreState(IMemento memento) {
        if (this.getSash() != null && memento != null) {
            Boolean hasMemento = this.getExpandProperty(memento);
            if (hasMemento != null) {
                this.previousWidths = this.getWeightProperties(memento);
                this.sectionExpanded = hasMemento;
                this.refreshEditorContents();
                this.saveCurrentMemento(memento);
            } else {
                this.saveState(memento);
            }
            this.getSash().setWeights(this.previousWidths);
        }
    }

    protected void saveCurrentMemento(IMemento memento) {
        StatechartDefinitionSection.memento = memento;
    }

    protected void setMementoProperties(IMemento memento) {
        String sectionProperty = this.getSectionProperty(this.getContextObject());
        if (this.previousWidths.length >= 2) {
            memento.putInteger(sectionProperty + MEM_FIRST_WEIGHT, this.previousWidths[0]);
            memento.putInteger(sectionProperty + MEM_SECOND_WEIGHT, this.previousWidths[1]);
        }
        memento.putBoolean(sectionProperty + MEM_EXPANDED, this.sectionExpanded);
    }

    protected String getSectionProperty(EObject element) {
        return this.stripElementName(((NamedElement)element).getName());
    }

    protected String stripElementName(String name) {
        if (name != null) {
            return IdentifierConverter.toIdentifier((String)name);
        }
        return "";
    }

    protected Boolean getExpandProperty(IMemento memento) {
        String expandProperty = this.getSectionProperty(this.getContextObject()) + MEM_EXPANDED;
        return memento.getBoolean(expandProperty);
    }

    protected int[] getWeightProperties(IMemento memento) {
        String sectionProperty = this.getSectionProperty(this.getContextObject());
        Integer first = memento.getInteger(sectionProperty + MEM_FIRST_WEIGHT);
        Integer second = memento.getInteger(sectionProperty + MEM_SECOND_WEIGHT);
        if (first != null && second != null) {
            return new int[]{first, second};
        }
        return DEFAULT_WEIGHTS;
    }

    public String getDefinition() {
        if (this.isInlined()) {
            return null;
        }
        return this.embeddedEditor.getDocument().get();
    }

    protected class CollapsedBorder
    extends Canvas
    implements MouseListener,
    MouseTrackListener,
    PaintListener {
        private String text;
        float rotationAngle;
        private Font font;
        private Cursor arrowCursor;
        private Cursor handCursor;

        public CollapsedBorder(Composite parent, int style) {
            super(parent, style);
            this.rotationAngle = -90.0f;
            this.font = new Font((Device)this.getDisplay(), "Segoe UI", 8, 0);
            this.arrowCursor = new Cursor((Device)this.getDisplay(), 0);
            this.handCursor = new Cursor((Device)this.getDisplay(), 21);
            this.setText("Definition section", this.font);
            GridDataFactory.fillDefaults().grab(false, false).span(2, 1).hint(0, parent.getBounds().height).applyTo((Control)this);
            this.addPaintListener(this);
            this.addMouseListener(this);
            this.addMouseTrackListener(this);
        }

        public void setText(String string, Font font) {
            this.text = string;
            this.setFont(font);
            StatechartDefinitionSection.this.refresh((Composite)this);
        }

        public void paintControl(PaintEvent e) {
            int w = e.width;
            int h = e.height;
            Transform tr = new Transform((Device)e.display);
            tr.translate((float)(w / 2), (float)(h / 2));
            tr.rotate(this.rotationAngle);
            e.gc.setTransform(tr);
            tr.dispose();
            int drawHeight = -w + 2;
            e.gc.drawString(StatechartDefinitionSection.this.sectionExpanded ? "" : this.text, 0, drawHeight % 2 != 0 ? drawHeight + 1 : drawHeight - 1);
        }

        public void mouseUp(MouseEvent e) {
            if (!StatechartDefinitionSection.this.sectionExpanded) {
                StatechartDefinitionSection.this.toggleExpandState();
            }
            this.setCursor(this.arrowCursor);
        }

        public void mouseDown(MouseEvent e) {
            if (StatechartDefinitionSection.this.mouseListener != null && !StatechartDefinitionSection.this.sectionExpanded) {
                StatechartDefinitionSection.this.toggleExpandState();
            }
        }

        public void mouseEnter(MouseEvent e) {
            this.setCursor(!StatechartDefinitionSection.this.sectionExpanded ? this.handCursor : this.arrowCursor);
            this.setToolTipText(!StatechartDefinitionSection.this.sectionExpanded ? StatechartDefinitionSection.SHOW_SECTION_TOOLTIP : null);
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void dispose() {
            this.removePaintListener(this);
            this.removeMouseListener(this);
            this.removeMouseTrackListener(this);
            this.handCursor.dispose();
            this.arrowCursor.dispose();
            this.font.dispose();
            super.dispose();
        }
    }

    protected class DefinitionSectionSynchronizer
    extends AdapterImpl {
        protected DefinitionSectionSynchronizer() {
        }

        public void notifyChanged(Notification notification) {
            if (1 == notification.getEventType() && BasePackage.Literals.NAMED_ELEMENT__NAME.equals(notification.getFeature())) {
                String newText = notification.getNewStringValue();
                String oldText = StatechartDefinitionSection.this.nameLabel.getText();
                if (!oldText.equals(newText)) {
                    StatechartDefinitionSection.this.nameLabel.setText(newText);
                }
            }
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof DefinitionSectionSynchronizer;
        }
    }

    protected class InlineIcon
    extends Composite
    implements MouseListener,
    MouseTrackListener,
    PaintListener {
        protected static final String INLINE_TOOLTIP = "Inline definition section";
        private Cursor handCursor;
        private boolean iconHasFocus;
        private Label icon;

        public InlineIcon(Composite parent, int style) {
            super(parent, style);
            this.handCursor = new Cursor((Device)this.getDisplay(), 21);
            this.iconHasFocus = false;
            GridLayoutFactory.fillDefaults().applyTo((Composite)this);
            this.icon = new Label((Composite)this, style);
            this.icon.setCursor(this.handCursor);
            this.icon.setImage(StatechartImages.PIN.image());
            this.icon.setToolTipText(INLINE_TOOLTIP);
            this.icon.setEnabled(StatechartDefinitionSection.this.isStatechart());
            this.icon.addMouseListener((MouseListener)this);
            this.icon.addMouseTrackListener((MouseTrackListener)this);
            this.icon.addPaintListener((PaintListener)this);
        }

        public void mouseUp(MouseEvent e) {
            StatechartDefinitionSection.this.toggleDefinitionSection();
            StatechartDefinitionSection.this.saveState(memento);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            this.iconHasFocus = true;
            this.icon.redraw();
        }

        public void mouseExit(MouseEvent e) {
            this.iconHasFocus = false;
            this.icon.redraw();
        }

        public void paintControl(PaintEvent e) {
            if (this.iconHasFocus) {
                this.drawIconBorder(this.icon, e.gc);
            }
        }

        protected void drawIconBorder(Label icon, GC gc) {
            Rectangle rect = new Rectangle(0, 0, icon.getBounds().width - 1, icon.getBounds().height - 1);
            Transform t = new Transform((Device)this.getDisplay());
            gc.setTransform(t);
            t.dispose();
            gc.setForeground(ColorConstants.lightGray);
            gc.drawRectangle(0, 0, rect.width, rect.height);
        }

        public void dispose() {
            this.icon.removeMouseListener((MouseListener)this);
            this.icon.removeMouseTrackListener((MouseTrackListener)this);
            this.icon.removePaintListener((PaintListener)this);
            this.handCursor.dispose();
            this.icon.dispose();
            super.dispose();
        }
    }

    protected class ResizeListener
    extends ControlAdapter {
        private static final int DELAY = 150;
        private Job resizeFinishedJob = new Job("Resizing..."){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (StatechartDefinitionSection.this.isDisposed() || StatechartDefinitionSection.this.getSash().isDisposed()) {
                            return;
                        }
                        if (((ResizeListener)(this).ResizeListener.this).StatechartDefinitionSection.this.sectionExpanded) {
                            ((ResizeListener)(this).ResizeListener.this).StatechartDefinitionSection.this.previousWidths = StatechartDefinitionSection.this.getSash().getWeights();
                            StatechartDefinitionSection.this.saveState(memento);
                        } else if (((ResizeListener)(this).ResizeListener.this).StatechartDefinitionSection.this.getBounds().width != StatechartDefinitionSection.this.getSwitchControlWidth()) {
                            StatechartDefinitionSection.this.collapseDefinitionSection();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };

        protected ResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            this.handleControlChanged();
        }

        public void controlMoved(ControlEvent e) {
            this.handleControlChanged();
        }

        protected void handleControlChanged() {
            this.resizeFinishedJob.cancel();
            this.resizeFinishedJob.schedule(150L);
        }
    }
}

