/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.partitioning;

import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.provider.SGraphItemProviderAdapterFactory;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningBreadcrumbViewer;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningDocumentProvider;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sct.ui.editor.partitioning.SubmachineEditorInput;
import com.yakindu.sct.ui.editor.providers.PaletteViewerExFixed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.xtext.util.Arrays;

public abstract class DiagramPartitioningEditor
extends DiagramDocumentEditor
implements ISelectionChangedListener,
IEditingDomainProvider {
    protected static final int SASH_WIDTH = 5;
    private DiagramPartitioningBreadcrumbViewer viewer;
    private DiagramPartitioningDocumentProvider documentProvider = new DiagramPartitioningDocumentProvider();
    private Adapter breadcrumbSynchronizer;
    private SashForm sash;

    protected abstract void createTextEditor(Composite var1);

    protected abstract EObject getContextObject();

    public DiagramPartitioningEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return DiagramPartitioningUtil.getSharedDomain();
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof FileStoreEditorInput) {
            throw new PartInitException("An error occured while opening the file.\n\nThis might have happened because you tried to open a statechart with File->Open File.\nThis is not supported. Please import the file into a project instead.");
        }
        super.init(site, input);
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        try {
            super.doSetInput(input, releaseEditorContents);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object getAdapter(Class type) {
        if (DiagramPartitioningEditor.class.equals((Object)type)) {
            return this;
        }
        return super.getAdapter(type);
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        this.createBreadcrumbViewer(parent);
        this.sash = (SashForm)this.createParentSash(parent);
        this.createTextEditor((Composite)this.sash);
        super.createPartControl((Composite)this.sash);
    }

    protected PaletteViewer constructPaletteViewer() {
        return new PaletteViewerExFixed();
    }

    protected Composite createParentSash(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        SashForm sash = new SashForm(parent, 256);
        sash.setBackground(ColorConstants.white);
        sash.setSashWidth(5);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sash);
        GridLayoutFactory.fillDefaults().applyTo((Composite)sash);
        return sash;
    }

    protected void sanityCheckState(IEditorInput input) {
        super.sanityCheckState(input);
        if (this.getDiagram() != null && this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput(DiagramPartitioningUtil.getDiagramContainerHierachy(this.getDiagram()));
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof SubmachineEditorInput) {
            this.initializeTitle((SubmachineEditorInput)input);
        } else if (input instanceof IDiagramEditorInput) {
            this.initializeTitle((IDiagramEditorInput)input);
        }
    }

    protected void initializeTitle(SubmachineEditorInput input) {
        Diagram diagram = input.getDiagram();
        EObject element = diagram.getElement();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory());
        this.setTitleImage(labelProvider.getImage((Object)element));
        this.initializeTitle(diagram);
        this.setPartName(input.getContext() + " : " + labelProvider.getText((Object)element));
    }

    protected void initializeTitle(IDiagramEditorInput input) {
        Diagram diagram = input.getDiagram();
        EObject element = diagram.getElement();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory());
        this.setTitleImage(labelProvider.getImage((Object)element));
        this.setPartName(labelProvider.getText((Object)element));
    }

    protected void initializeTitle(Diagram diagram) {
        EObject element = diagram.getElement();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory());
        this.setTitleImage(labelProvider.getImage((Object)element));
        this.setPartName(labelProvider.getText((Object)element));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.configureContextMenu();
    }

    protected void configureContextMenu() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        FilteringDiagramContextMenuProvider provider = new FilteringDiagramContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)graphicalViewer);
        graphicalViewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)this.viewer);
    }

    protected void createBreadcrumbViewer(Composite parent) {
        if (this.viewer == null) {
            this.viewer = new DiagramPartitioningBreadcrumbViewer(parent, 8);
            this.viewer.addSelectionChangedListener(this);
            this.viewer.setContentProvider((IContentProvider)new BreadcrumbViewerContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new BreadcrumbViewerLabelProvider());
            List<Diagram> diagramContainerHierachy = DiagramPartitioningUtil.getDiagramContainerHierachy(this.getDiagram());
            this.initBreadcrumbSynchronizer(diagramContainerHierachy);
            this.viewer.setInput(diagramContainerHierachy);
        }
        parent.pack(true);
    }

    protected void createGraphicalViewer(Composite parent) {
        super.createGraphicalViewer(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Diagram diagramToOpen = (Diagram)((IStructuredSelection)event.getSelection()).getFirstElement();
        DiagramPartitioningUtil.openEditor(diagramToOpen);
    }

    public void dispose() {
        this.closeSubdiagramEditors();
        if (this.getDiagram() != null) {
            this.removeBreadcrumbSynchronizer(DiagramPartitioningUtil.getDiagramContainerHierachy(this.getDiagram()));
        }
        super.dispose();
    }

    protected void closeSubdiagramEditors() {
        if (this.getDiagram() != null && this.getDiagram().getElement() instanceof Statechart) {
            boolean close;
            IEditorReference[] refs;
            ArrayList<IEditorReference> refsToClose = new ArrayList<IEditorReference>();
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = workbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IEditorReference[] iEditorReferenceArray = refs = activePage.getEditorReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                try {
                    IDiagramEditorInput diagramInput;
                    if (ref.getEditorInput() instanceof IDiagramEditorInput && (diagramInput = (IDiagramEditorInput)ref.getEditorInput()).getDiagram().eResource() == this.getDiagram().eResource()) {
                        refsToClose.add(ref);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            if (refsToClose.size() > 0 && (close = MessageDialog.openQuestion((Shell)activePage.getActivePart().getSite().getShell(), (String)"Close subdiagram editors?", (String)"There are still subdiagram editors open. Do you want to close them?"))) {
                for (IEditorReference ref : refsToClose) {
                    activePage.closeEditor(ref.getEditor(false), false);
                }
            }
        }
    }

    protected void refreshDiagramEditPartChildren() {
        this.getDiagramEditPart().getChildren().forEach(part -> {
            if (part instanceof EditPart) {
                ((EditPart)part).refresh();
            }
        });
    }

    protected void initBreadcrumbSynchronizer(List<Diagram> diagramContainerHierachy) {
        this.breadcrumbSynchronizer = this.createBreadcrumbSynchronizer();
        for (Diagram diagram : diagramContainerHierachy) {
            diagram.getElement().eAdapters().add((Object)this.breadcrumbSynchronizer);
        }
    }

    protected void removeBreadcrumbSynchronizer(List<Diagram> diagramContainerHierachy) {
        for (Diagram diagram : diagramContainerHierachy) {
            diagram.getElement().eAdapters().remove((Object)this.breadcrumbSynchronizer);
        }
        this.breadcrumbSynchronizer = null;
    }

    protected Adapter createBreadcrumbSynchronizer() {
        return new BreadcrumbSynchronizer();
    }

    public void firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    private final class BreadcrumbSynchronizer
    extends AdapterImpl {
        private BreadcrumbSynchronizer() {
        }

        public void notifyChanged(Notification notification) {
            Object feature;
            if (1 == notification.getEventType() && (feature = notification.getFeature()) != null && feature.equals(BasePackage.Literals.NAMED_ELEMENT__NAME)) {
                DiagramPartitioningEditor.this.viewer.refresh();
                if (DiagramPartitioningEditor.this.getDiagram().getElement() instanceof State) {
                    DiagramPartitioningEditor.this.initializeTitle(DiagramPartitioningEditor.this.getDiagram());
                }
            }
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof BreadcrumbSynchronizer;
        }
    }

    public static final class BreadcrumbViewerContentProvider
    implements ITreePathContentProvider {
        private List<IFile> input;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof List) {
                this.input = (List)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(TreePath parentPath) {
            return this.input.subList(parentPath.getSegmentCount(), this.input.size()).toArray();
        }

        public void dispose() {
            this.input = null;
        }

        public boolean hasChildren(TreePath path) {
            return false;
        }

        public TreePath[] getParents(Object element) {
            return null;
        }
    }

    public static final class BreadcrumbViewerLabelProvider
    extends BaseLabelProvider
    implements ITreePathLabelProvider {
        public void updateLabel(ViewerLabel label, TreePath elementPath) {
            Diagram lastSegment = (Diagram)elementPath.getLastSegment();
            NamedElement element = (NamedElement)lastSegment.getElement();
            AdapterFactoryLabelProvider provider = new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory());
            label.setText(provider.getText((Object)element).replaceFirst("Statechart", ""));
            if (element instanceof Statechart) {
                label.setImage(StatechartImages.LOGO.image());
            } else {
                label.setImage(provider.getImage((Object)element));
            }
        }
    }

    public static class FilteringDiagramContextMenuProvider
    extends DiagramContextMenuProvider {
        protected String[] exclude = new String[]{"addNoteLinkAction", "properties", "org.eclipse.mylyn.context.ui.commands.attachment.retrieveContext", "org.eclipse.jst.ws.atk.ui.webservice.category.popupMenu", "org.eclipse.tptp.platform.analysis.core.ui.internal.actions.MultiAnalysisActionDelegate", "org.eclipse.debug.ui.contextualLaunch.profile.submenu", "org.eclipse.cdt.ui.buildConfigContributionM", "org.eclipse.mylyn.resources.ui.ui.interest.remove.element", "formatMenu", "filtersMenu", "addGroup", "navigateGroup", "toolbarArrangeAllAction", "selectMenu", "diagramAddMenu", "navigateMenu", "viewGroup", "viewMenu", "compareWithMenu", "replaceWithMenu", "team.main", "navigateGroup", "navigateMenu"};

        protected FilteringDiagramContextMenuProvider(IWorkbenchPart part, EditPartViewer viewer) {
            super(part, viewer);
        }

        protected boolean allowItem(IContributionItem itemToAdd) {
            if (itemToAdd.getId() != null && (itemToAdd.getId().contains("papyrus") || Arrays.contains((Object[])this.exclude, (Object)itemToAdd.getId()))) {
                itemToAdd.setVisible(false);
            }
            return true;
        }
    }
}

