/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.propertysheets;

import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.ui.editor.DiagramActivator;
import java.net.URL;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class SheetLabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    public String getText(Object element) {
        if ((element = this.unwrap(element)) instanceof IGraphicalEditPart) {
            EObject semanticElement = ((IGraphicalEditPart)element).resolveSemanticElement();
            if (semanticElement == null) {
                View view = ((IGraphicalEditPart)element).getNotationView();
                return view.getType();
            }
            IElementType elementType = ElementTypeRegistry.getInstance().getElementType(semanticElement);
            StringBuilder builder = new StringBuilder();
            builder.append(elementType.getDisplayName());
            if (semanticElement instanceof NamedElement && ((NamedElement)semanticElement).getName() != null) {
                builder.append(' ');
                builder.append(((NamedElement)semanticElement).getName());
            }
            return builder.toString();
        }
        return null;
    }

    public Image getImage(Object element) {
        if ((element = this.unwrap(element)) instanceof IGraphicalEditPart) {
            EObject semanticElement = ((IGraphicalEditPart)element).resolveSemanticElement();
            if (semanticElement == null) {
                View view = ((IGraphicalEditPart)element).getNotationView();
                String viewType = view.getType();
                if (ViewType.NOTE.equals(viewType)) {
                    return SharedImages.get((String)"icons/note.gif");
                }
                if (ViewType.TEXT.equals(viewType)) {
                    return SharedImages.get((String)"icons/text.gif");
                }
            } else {
                IElementType elementType = ElementTypeRegistry.getInstance().getElementType(semanticElement);
                Image image = DiagramActivator.getDefault().getImageRegistry().get(elementType.getIconURL().toString());
                if (image == null) {
                    ImageDescriptor desc = ImageDescriptor.createFromURL((URL)elementType.getIconURL());
                    DiagramActivator.getDefault().getImageRegistry().put(elementType.getIconURL().toString(), desc.createImage());
                    return DiagramActivator.getDefault().getImageRegistry().get(elementType.getIconURL().toString());
                }
                return image;
            }
        }
        return null;
    }

    private Object unwrap(Object element) {
        if (element instanceof IStructuredSelection) {
            return ((IStructuredSelection)element).getFirstElement();
        }
        return element;
    }
}

