/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.ws;

import com.yakindu.sct.generator.core.filesystem.ISCTWorkspaceAccess;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DefaultSCTWorkspaceAccess
implements ISCTWorkspaceAccess {
    public boolean projectExists(String value) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(value).exists();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean projectOpened(String value) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(value).isOpen();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean folderExists(String projectName, String folderPath) {
        try {
            IPath workspaceRelativePath = Path.fromPortableString((String)projectName).append(folderPath);
            return ResourcesPlugin.getWorkspace().getRoot().exists(workspaceRelativePath);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean fileExists(String projectName, String folderPath) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile((IPath)new Path(folderPath)).exists();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void refreshProject(String projectName) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null && project.isAccessible()) {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

