/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.c.extensions.FileNaming;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.c.types.CTypes;
import com.yakindu.sct.generator.core.artifacts.IContentTemplate;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class TimerServiceSource
implements IContentTemplate<ExecutionFlow> {
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    protected FileNaming _fileNaming;
    @Inject
    @Extension
    private CTypes _cTypes;

    public String content(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _h = this._fileNaming.h(this._fileNaming.timerServiceModule());
        _builder.append(_h);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include <stddef.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void reset_task_data(task_data *data)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("switch (data->type) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("case TIME_EVENT_TASK:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("data->get.time_ms = 0;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("data->get.time_event.raise_event = sc_null;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("data->get.time_event.pt_evid = 0;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("data->get.time_event.periodic = bool_false;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("case RUNCYCLE_TASK:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("data->get.time_ms = 0;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("data->get.run_cycle = sc_null;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data->type = EMPTY_TASK;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data->get.statemachine = NULL;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void execute(task_data *data)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("switch (data->type) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("case TIME_EVENT_TASK: {");
        _builder.newLine();
        _builder.append("    \t");
        _builder.append("/* Fire the event. */");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("sc_raise_time_event_fp raise_event = data->get.time_event.raise_event;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("void *statemachine = data->get.statemachine;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (raise_event != NULL && statemachine != NULL) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("raise_event(statemachine, data->get.time_event.pt_evid);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("case RUNCYCLE_TASK: {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("sc_run_cycle_fp run_cycle = data->get.run_cycle;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("void *statemachine = data->get.statemachine;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (run_cycle != NULL) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("run_cycle(statemachine);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void update_elapsed_time_ms(sc_timer_t *task, ");
        String _name = this._cTypes.sc_time().name();
        _builder.append(_name);
        _builder.append(" elapsed_time_ms_)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("task->elapsed_time_ms += elapsed_time_ms_;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _name_1 = this._cTypes.sc_bool().name();
        _builder.append(_name_1);
        _builder.append(" is_periodic(sc_timer_t *task)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("task_type type;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("type = task->data.type;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("switch (type) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("case TIME_EVENT_TASK:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return task->data.get.time_event.periodic;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("case RUNCYCLE_TASK:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return bool_true;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return bool_false;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _name_2 = this._cTypes.sc_bool().name();
        _builder.append(_name_2);
        _builder.append(" is_runcycle_event(sc_timer_t *task)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return task->data.type == RUNCYCLE_TASK;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void reset_timer_task(sc_timer_t *task)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("reset_task_data(&task->data);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("task->elapsed_time_ms = 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("Compare tasks based on their execution order.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("Return true if this task is always to be executed strictly before the other task if both are scheduled to run at the same time.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("Default behavior:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("- This task is to be scheduled strictly before the other task if its is_runcycle_event() method does not return true and the other task's is_runcycle_event() method returns true.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        String _name_3 = this._cTypes.sc_bool().name();
        _builder.append(_name_3);
        _builder.append(" less_than(sc_timer_t *task, sc_timer_t *other)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return !is_runcycle_event(task) && is_runcycle_event(other);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _name_4 = this._cTypes.sc_bool().name();
        _builder.append(_name_4);
        _builder.append(" time_event_matcher(match_time_event *matcher, const sc_timer_t *other)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return (matcher->statemachine == NULL || matcher->statemachine == other->data.get.statemachine) && matcher->pt_evid == other->data.get.time_event.pt_evid;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _name_5 = this._cTypes.sc_bool().name();
        _builder.append(_name_5);
        _builder.append(" run_cycle_matcher(match_run_cycle_of *matcher, const sc_timer_t *other)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return matcher->statemachine == other->data.get.statemachine;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void set_generic_timer(sc_timer_service_t *timer_service, const task_data data)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        String _name_6 = this._cTypes.sc_integer().name();
        _builder.append(_name_6, "    ");
        _builder.append(" inserted_task_idx;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("sc_timer_t *inserted_task;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Do nothing if there are no free slots. */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (timer_service->next_free_task >= timer_service->length) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Insert task at the front. */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("inserted_task_idx = timer_service->next_free_task;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("inserted_task = &(timer_service->tasks[inserted_task_idx]);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("inserted_task->data = data;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("inserted_task->elapsed_time_ms = 0;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->next_free_task = inserted_task->next_task_idx;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("inserted_task->next_task_idx = timer_service->next_active_task;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->next_active_task = inserted_task_idx;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void unset_generic_timer(sc_timer_service_t *timer_service, timer_task_matcher *matcher)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        String _name_7 = this._cTypes.sc_integer().name();
        _builder.append(_name_7, "    ");
        _builder.append(" last_position;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_8 = this._cTypes.sc_integer().name();
        _builder.append(_name_8, "    ");
        _builder.append(" next_position;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("sc_timer_t *current_task;");
        _builder.newLine();
        _builder.append("    ");
        String _name_9 = this._cTypes.sc_bool().name();
        _builder.append(_name_9, "    ");
        _builder.append(" match_result;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_10 = this._cTypes.sc_integer().name();
        _builder.append(_name_10, "    ");
        _builder.append(" current_position;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("last_position = timer_service->length;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("next_position = timer_service->next_active_task;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("while (next_position < timer_service->length) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("current_task = &timer_service->tasks[next_position];");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("match_result = bool_false;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (matcher->is_match_time_event) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("match_result = time_event_matcher(&matcher->data.match_time_event_, current_task);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("match_result = run_cycle_matcher(&matcher->data.match_run_cycle_of_, current_task);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (match_result) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("reset_timer_task(current_task);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("if (last_position < timer_service->length) {");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("timer_service->tasks[last_position].next_task_idx = current_task->next_task_idx;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("timer_service->next_active_task = current_task->next_task_idx;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("current_position = next_position;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("next_position = current_task->next_task_idx;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("current_task->next_task_idx = timer_service->next_free_task;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("timer_service->next_free_task = current_position;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("last_position = next_position;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("next_position = current_task->next_task_idx;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_timer_service_init(sc_timer_service_t *timer_service,");
        _builder.newLine();
        _builder.append("                           ");
        _builder.append("sc_timer_t *tasks_,");
        _builder.newLine();
        _builder.append("                           ");
        String _name_11 = this._cTypes.sc_integer().name();
        _builder.append(_name_11, "                           ");
        _builder.append(" length_,");
        _builder.newLineIfNotEmpty();
        _builder.append("                           ");
        _builder.append("sc_raise_time_event_fp raise_event)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        String _name_12 = this._cTypes.sc_integer().name();
        _builder.append(_name_12, "    ");
        _builder.append(" i;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->length = length_;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->tasks = tasks_;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->next_active_task = length_;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->next_free_task = 0;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("for (i = 0; i < timer_service->length; i++) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer_service->tasks[i].next_task_idx = i + 1;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer_service->tasks[i].elapsed_time_ms = 0;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer_service->tasks[i].data.type = EMPTY_TASK;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->raise_event = raise_event;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*! Start the timing for a time event.*/");
        _builder.newLine();
        _builder.append("void sc_timer_set(sc_timer_service_t *timer_service,");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("void *handle,");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("const ");
        String _name_13 = this._cTypes.sc_eventid().name();
        _builder.append(_name_13, "                  ");
        _builder.append(" evid,");
        _builder.newLineIfNotEmpty();
        _builder.append("                  ");
        _builder.append("const ");
        String _name_14 = this._cTypes.sc_time().name();
        _builder.append(_name_14, "                  ");
        _builder.append(" time_ms,");
        _builder.newLineIfNotEmpty();
        _builder.append("                  ");
        _builder.append("const ");
        String _name_15 = this._cTypes.sc_bool().name();
        _builder.append(_name_15, "                  ");
        _builder.append(" periodic)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("sc_raise_time_event_fp raise_event = timer_service->raise_event;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("sc_timer_set_for_raise_event(timer_service, raise_event, handle, evid, time_ms, periodic);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_timer_set_for_raise_event(sc_timer_service_t *timer_service,");
        _builder.newLine();
        _builder.append("                              ");
        _builder.append("sc_raise_time_event_fp raise_event,");
        _builder.newLine();
        _builder.append("                              ");
        _builder.append("void *statemachine,");
        _builder.newLine();
        _builder.append("                              ");
        _builder.append("const ");
        String _name_16 = this._cTypes.sc_eventid().name();
        _builder.append(_name_16, "                              ");
        _builder.append(" evid,");
        _builder.newLineIfNotEmpty();
        _builder.append("                              ");
        _builder.append("const ");
        String _name_17 = this._cTypes.sc_time().name();
        _builder.append(_name_17, "                              ");
        _builder.append(" time_ms,");
        _builder.newLineIfNotEmpty();
        _builder.append("                              ");
        _builder.append("const ");
        String _name_18 = this._cTypes.sc_bool().name();
        _builder.append(_name_18, "                              ");
        _builder.append(" periodic)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("task_data data;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.type = TIME_EVENT_TASK;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_ms = time_ms;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.statemachine = statemachine;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.run_cycle = NULL;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_event.raise_event = raise_event;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_event.pt_evid = evid;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_event.periodic = periodic;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("set_generic_timer(timer_service, data);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*! Unset the given time event.*/");
        _builder.newLine();
        _builder.append("void sc_timer_unset(sc_timer_service_t *timer_service, ");
        String _name_19 = this._cTypes.sc_eventid().name();
        _builder.append(_name_19);
        _builder.append(" evid)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("void *statemachine;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("statemachine = NULL;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("sc_timer_unset_for_machine(timer_service, evid, statemachine);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_timer_unset_for_machine(sc_timer_service_t *timer_service,");
        _builder.newLine();
        _builder.append("                                 ");
        String _name_20 = this._cTypes.sc_eventid().name();
        _builder.append(_name_20, "                                 ");
        _builder.append(" evid,");
        _builder.newLineIfNotEmpty();
        _builder.append("                                 ");
        _builder.append("void *statemachine)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_task_matcher matcher;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("matcher.is_match_time_event = bool_true;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("matcher.data.match_time_event_.statemachine = statemachine;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("matcher.data.match_time_event_.pt_evid = evid;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("unset_generic_timer(timer_service, &matcher);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*! Set a timer for running cycles of the given statemachine.*/");
        _builder.newLine();
        _builder.append("void set_runcycle_timer_for(sc_timer_service_t *timer_service,");
        _builder.newLine();
        _builder.append("                             ");
        _builder.append("sc_run_cycle_fp run_cycle,");
        _builder.newLine();
        _builder.append("                             ");
        _builder.append("void *statemachine,");
        _builder.newLine();
        _builder.append("                             ");
        String _name_21 = this._cTypes.sc_time().name();
        _builder.append(_name_21, "                             ");
        _builder.append(" cycle_period)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("task_data data;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.type = RUNCYCLE_TASK;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_event.raise_event = NULL;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_event.periodic = bool_false;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_event.pt_evid = 0;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.time_ms = cycle_period;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.run_cycle = run_cycle;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("data.get.statemachine = statemachine;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("set_generic_timer(timer_service, data);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*! Unset timers for running cycles of the given statemachine.*/");
        _builder.newLine();
        _builder.append("void unset_runcycle_timer(sc_timer_service_t *timer_service, void *statemachine)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_task_matcher matcher;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("matcher.is_match_time_event = bool_false;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("matcher.data.match_run_cycle_of_.statemachine = statemachine;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("unset_generic_timer(timer_service, &matcher);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*!");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This function must be called by the user. The elapsed time must be calculated every time,");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* the function gets called.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void sc_timer_service_proceed(sc_timer_service_t *timer_service, ");
        String _name_22 = this._cTypes.sc_time().name();
        _builder.append(_name_22);
        _builder.append(" elapsed_ms)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        String _name_23 = this._cTypes.sc_time().name();
        _builder.append(_name_23, "    ");
        _builder.append(" time_to_proceed;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_24 = this._cTypes.sc_time().name();
        _builder.append(_name_24, "    ");
        _builder.append(" proceeded_time;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_25 = this._cTypes.sc_integer().name();
        _builder.append(_name_25, "    ");
        _builder.append(" idx;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_26 = this._cTypes.sc_bool().name();
        _builder.append(_name_26, "    ");
        _builder.append(" task_fired;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_27 = this._cTypes.sc_integer().name();
        _builder.append(_name_27, "    ");
        _builder.append(" before_best;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_28 = this._cTypes.sc_integer().name();
        _builder.append(_name_28, "    ");
        _builder.append(" best;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_29 = this._cTypes.sc_time().name();
        _builder.append(_name_29, "    ");
        _builder.append(" best_remaining_time;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_30 = this._cTypes.sc_integer().name();
        _builder.append(_name_30, "    ");
        _builder.append(" last_task;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_31 = this._cTypes.sc_integer().name();
        _builder.append(_name_31, "    ");
        _builder.append(" next_task;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_32 = this._cTypes.sc_time().name();
        _builder.append(_name_32, "    ");
        _builder.append(" remaining_time;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_33 = this._cTypes.sc_time().name();
        _builder.append(_name_33, "    ");
        _builder.append(" time_till_next_task_;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (timer_service->next_active_task >= timer_service->length) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("time_till_next_task_ = time_till_next_task(timer_service);");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("time_to_proceed = time_till_next_task_ < elapsed_ms");
        _builder.newLine();
        _builder.append("                                     ");
        _builder.append("? time_till_next_task_");
        _builder.newLine();
        _builder.append("                                     ");
        _builder.append(": elapsed_ms;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("proceeded_time = 0;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("while (time_to_proceed > 0) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("idx = timer_service->next_active_task;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("while (idx < timer_service->length) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("sc_timer_t *current_task;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("current_task = &timer_service->tasks[idx];");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("update_elapsed_time_ms(current_task, time_to_proceed);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("idx = current_task->next_task_idx;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("do {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("task_fired = bool_false;");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("before_best = timer_service->length;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("best = timer_service->next_active_task;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("best_remaining_time = timer_service->tasks[best].data.get.time_ms");
        _builder.newLine();
        _builder.append("                                             ");
        _builder.append("- timer_service->tasks[best].elapsed_time_ms;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("last_task = best;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("next_task = timer_service->tasks[best].next_task_idx;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("while (next_task < timer_service->length) {");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("sc_timer_t current_task;");
        _builder.newLine();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("current_task = timer_service->tasks[next_task];");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("remaining_time = current_task.data.get.time_ms");
        _builder.newLine();
        _builder.append("                                            ");
        _builder.append("- current_task.elapsed_time_ms;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (remaining_time < best_remaining_time");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("|| (remaining_time == best_remaining_time");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("&& !(less_than(&timer_service->tasks[best], &current_task)))) {");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("best = next_task;");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("before_best = last_task;");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("best_remaining_time = remaining_time;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("last_task = next_task;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("next_task = current_task.next_task_idx;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("if (best_remaining_time <= 0) {");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("sc_timer_t *best_task;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("task_data data;");
        _builder.newLine();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("best_task = &timer_service->tasks[best];");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("data = best_task->data;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (is_periodic(best_task)) {");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("best_task->elapsed_time_ms = 0;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("reset_timer_task(best_task);");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("if (before_best < timer_service->length) {");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("timer_service->tasks[before_best].next_task_idx = best_task->next_task_idx;");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("timer_service->next_active_task = best_task->next_task_idx;");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("best_task->next_task_idx = timer_service->next_free_task;");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("timer_service->next_free_task = best;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("execute(&data);");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("task_fired = bool_true;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("} while (task_fired && timer_service->next_active_task < timer_service->length);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("proceeded_time += time_to_proceed;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("time_till_next_task_  = time_till_next_task(timer_service);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("time_to_proceed = (time_till_next_task_ < elapsed_ms - proceeded_time)");
        _builder.newLine();
        _builder.append("                              ");
        _builder.append("? time_till_next_task_");
        _builder.newLine();
        _builder.append("                              ");
        _builder.append(": (elapsed_ms - proceeded_time);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*! Cancel timer service. Use this to end possible timing threads and free");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("memory resources.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void cancel(sc_timer_service_t *timer_service)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        String _name_34 = this._cTypes.sc_integer().name();
        _builder.append(_name_34, "    ");
        _builder.append(" idx;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("for (idx = 0; idx < timer_service->length; idx++) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("reset_timer_task(&timer_service->tasks[idx]);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer_service->tasks[idx].next_task_idx = idx + 1;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->next_active_task = timer_service->length;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer_service->next_free_task = 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*! Obtain the time (in ms) required to proceed to the next task.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t\t");
        _builder.newLine();
        String _name_35 = this._cTypes.sc_time().name();
        _builder.append(_name_35);
        _builder.append(" time_till_next_task(sc_timer_service_t *timer_service)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        String _name_36 = this._cTypes.sc_time().name();
        _builder.append(_name_36, "    ");
        _builder.append(" time;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_37 = this._cTypes.sc_integer().name();
        _builder.append(_name_37, "    ");
        _builder.append(" task;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _name_38 = this._cTypes.sc_time().name();
        _builder.append(_name_38, "    ");
        _builder.append(" remaining_time;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (timer_service->next_active_task == timer_service->length) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("time = timer_service->tasks[timer_service->next_active_task].data.get.time_ms");
        _builder.newLine();
        _builder.append("                      ");
        _builder.append("- timer_service->tasks[timer_service->next_active_task].elapsed_time_ms;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("task = timer_service->tasks[timer_service->next_active_task].next_task_idx;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("while (task < timer_service->length) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("sc_timer_t *current_task;");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("current_task = &timer_service->tasks[task];");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("remaining_time = current_task->data.get.time_ms - current_task->elapsed_time_ms;");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (remaining_time < time) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("time = remaining_time;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("task = current_task->next_task_idx;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return time;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

