/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class InvertEqualsExpressionFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public InvertEqualsExpressionFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static InvertEqualsExpressionFixCore createInvertEqualsFix(CompilationUnit compilationUnit, ASTNode node) {
        if (!(node instanceof MethodInvocation) && !((node = node.getParent()) instanceof MethodInvocation)) {
            return null;
        }
        MethodInvocation method = (MethodInvocation)node;
        String identifier = method.getName().getIdentifier();
        if (!"equals".equals(identifier) && !"equalsIgnoreCase".equals(identifier)) {
            return null;
        }
        List arguments = method.arguments();
        if (arguments.size() != 1) {
            return null;
        }
        Expression right = (Expression)arguments.get(0);
        ITypeBinding binding = right.resolveTypeBinding();
        if (!(binding == null || binding.isClass() || binding.isInterface() || binding.isEnum())) {
            return null;
        }
        Expression left = method.getExpression();
        String label = CorrectionMessages.QuickAssistProcessor_invertequals_description;
        return new InvertEqualsExpressionFixCore(label, compilationUnit, new InvertEqualsProposalOperation(method, left, right));
    }

    private static class InvertEqualsProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private MethodInvocation method;
        private Expression left;
        private Expression right;

        public InvertEqualsProposalOperation(MethodInvocation method, Expression left, Expression right) {
            this.method = method;
            this.left = left;
            this.right = right;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            if (this.left == null) {
                MethodInvocation replacement = ast.newMethodInvocation();
                replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)this.method.getName()));
                replacement.arguments().add(ast.newThisExpression());
                replacement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.right));
                rewrite.replace((ASTNode)this.method, (ASTNode)replacement, null);
            } else if (this.right instanceof ThisExpression) {
                MethodInvocation replacement = ast.newMethodInvocation();
                replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)this.method.getName()));
                replacement.arguments().add(rewrite.createCopyTarget((ASTNode)this.left));
                rewrite.replace((ASTNode)this.method, (ASTNode)replacement, null);
            } else {
                Expression leftExpression = ASTNodes.getUnparenthesedExpression(this.left);
                rewrite.replace((ASTNode)this.right, rewrite.createCopyTarget((ASTNode)leftExpression), null);
                if (this.right instanceof CastExpression || this.right instanceof Assignment || this.right instanceof ConditionalExpression || this.right instanceof InfixExpression) {
                    ParenthesizedExpression paren = ast.newParenthesizedExpression();
                    paren.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.right));
                    rewrite.replace((ASTNode)this.left, (ASTNode)paren, null);
                } else {
                    rewrite.replace((ASTNode)this.left, rewrite.createCopyTarget((ASTNode)this.right), null);
                }
            }
        }
    }
}

