/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view.decorator;

import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.util.ExecutionContextExtensions;
import com.yakindu.sct.simulation.ui.SimulationActivator;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.render.util.DiagramRenderUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SimulationImageRenderer {
    private ExecutionContextExtensions contextExtensions = new ExecutionContextExtensions();

    public Image renderImage(IFile file, ExecutionContext context) {
        Diagram diagram = this.getDiagramCopy(file);
        return this.renderImage(diagram, context);
    }

    public Image renderImage(Diagram diagram, ExecutionContext context) {
        this.highlightActiveStates(context, diagram);
        return this.renderImage(diagram);
    }

    public Image renderImage(Diagram diagram, List<? extends EObject> objects) {
        this.highlightElements(objects, diagram);
        return this.renderImage(diagram);
    }

    protected Image renderImage(Diagram diagram) {
        Assert.isNotNull((Object)diagram);
        return DiagramRenderUtil.renderToSWTImage((Diagram)diagram);
    }

    public void highlightActiveStates(ExecutionContext context, Diagram diagram) {
        this.highlightElements(this.contextExtensions.getAllActiveStates(context), diagram);
    }

    public void highlightElements(final List<? extends EObject> objects, final Diagram diagram) {
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)diagram), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                RGB rgbForeGround = PreferenceConverter.getColor((IPreferenceStore)SimulationActivator.getDefault().getPreferenceStore(), (String)"stateForegroundHighlightingColor");
                RGB rgbBackGround = PreferenceConverter.getColor((IPreferenceStore)SimulationActivator.getDefault().getPreferenceStore(), (String)"stateBackgroundHighlightingColor");
                RGB rgbTransitionActive = PreferenceConverter.getColor((IPreferenceStore)SimulationActivator.getDefault().getPreferenceStore(), (String)"transitionHighlightingColor");
                Color color = new Color((Device)Display.getDefault(), rgbForeGround);
                Integer foreGround = FigureUtilities.colorToInteger((Color)color);
                color.dispose();
                color = new Color((Device)Display.getDefault(), rgbBackGround);
                Integer background = FigureUtilities.colorToInteger((Color)color);
                color.dispose();
                color = new Color((Device)Display.getDefault(), rgbTransitionActive);
                Integer transitionActive = FigureUtilities.colorToInteger((Color)color);
                color.dispose();
                TreeIterator eAllContents = diagram.eAllContents();
                while (eAllContents.hasNext()) {
                    EObject next = (EObject)eAllContents.next();
                    if (!(next instanceof View)) continue;
                    for (EObject elementToHighlight : objects) {
                        ShapeStyle style;
                        EObject element = null;
                        if (next instanceof Node) {
                            element = ((Node)next).getElement();
                        } else if (next instanceof Edge) {
                            element = ((Edge)next).getElement();
                        }
                        if (element == null || !EcoreUtil.getURI((EObject)elementToHighlight).equals(EcoreUtil.getURI((EObject)element))) continue;
                        if (next instanceof Node) {
                            style = (ShapeStyle)((Node)next).getStyle(NotationPackage.Literals.SHAPE_STYLE);
                            if (style == null) continue;
                            style.setFillColor(background.intValue());
                            style.setLineColor(foreGround.intValue());
                            continue;
                        }
                        if (!(next instanceof Edge) || (style = (ConnectorStyle)((View)next).getStyle(NotationPackage.Literals.CONNECTOR_STYLE)) == null) continue;
                        style.setLineColor(transitionActive.intValue());
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public Diagram getDiagramCopy(IFile file) {
        Resource resource = this.reload(file);
        Diagram diagram = (Diagram)resource.getContents().get(1);
        return diagram;
    }

    private Resource reload(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(uri);
        Resource resource = factory.createResource(uri);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
        resourceSet.getResources().add((Object)resource);
        try {
            resource.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading resource", e);
        }
        return resource;
    }

    public Diagram getDiagramCopy(Diagram diagram) {
        Resource resource = this.reload(WorkspaceSynchronizer.getFile((Resource)diagram.eResource()));
        EList contents = resource.getContents();
        for (EObject eObject : contents) {
            if (!EcoreUtil.getURI((EObject)diagram).equals(EcoreUtil.getURI((EObject)eObject))) continue;
            return (Diagram)eObject;
        }
        return (Diagram)resource.getContents().get(1);
    }
}

