/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view.editing;

import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Type;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.simulation.ui.view.editing.ScopeSlotEditingSupport;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class EnumerationEditingSupport
extends ScopeSlotEditingSupport {
    public EnumerationEditingSupport(ColumnViewer viewer, ScopeSlotEditingSupport.ITypeSystemProvider provider) {
        super(viewer, provider);
    }

    @Override
    public CellEditor getCellEditor(Object element) {
        if (element instanceof ExecutionSlot) {
            EnumerationType e = this.getEnumerationType((ExecutionSlot)element);
            ArrayList<String> enumeratorNames = new ArrayList<String>();
            for (Enumerator enumerator : e.getEnumerator()) {
                enumeratorNames.add(enumerator.getName());
            }
            return new ComboBoxCellEditor((Composite)this.getViewer().getControl(), enumeratorNames.toArray(new String[0]), 8);
        }
        return null;
    }

    public EnumerationType getEnumerationType(ExecutionSlot element) {
        EnumerationType e = (EnumerationType)element.getType().getOriginType();
        return e;
    }

    @Override
    public Object getValue(Object element) {
        if (element instanceof ExecutionSlot) {
            EnumerationType e = this.getEnumerationType((ExecutionSlot)element);
            return e.getEnumerator().indexOf(((ExecutionSlot)element).getValue());
        }
        return null;
    }

    @Override
    protected Type getSupportedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canEdit(Object element) {
        if (element instanceof ExecutionSlot) {
            if (!((ExecutionSlot)element).isWritable()) {
                return false;
            }
            Type type = ((ExecutionSlot)element).getType();
            if (type != null) {
                type = type.getOriginType();
            }
            return type instanceof EnumerationType;
        }
        return false;
    }

    @Override
    protected Object convertValue(Object element, Object value) {
        if (element instanceof ExecutionSlot && value != null && value instanceof Integer) {
            int index = (Integer)value;
            index = index < 0 ? 0 : index;
            EnumerationType e = this.getEnumerationType((ExecutionSlot)element);
            return e.getEnumerator().get(index);
        }
        return null;
    }
}

