/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.ui.utils;

import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.resource.ResourceUtil;
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SearchUtils {
    private static void checkAndAdd(EObject element, List<EObject> result) {
        if (element instanceof FeatureCall) {
            element = ((FeatureCall)element).getFeature();
        }
        if (element instanceof ElementReferenceExpression) {
            element = ((ElementReferenceExpression)element).getReference();
        }
        if (element instanceof ActiveStateReferenceExpression) {
            element = ((ActiveStateReferenceExpression)element).getValue();
        }
        result.add(element);
    }

    public static List<EObject> getModelElement(ISelection selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selection instanceof IStructuredSelection) {
            for (Object selectionElement : (IStructuredSelection)selection) {
                EObject element;
                if (selectionElement instanceof EObject) {
                    SearchUtils.checkAndAdd((EObject)selectionElement, result);
                    continue;
                }
                if (selectionElement instanceof IGraphicalEditPart) {
                    IGraphicalEditPart editPart = (IGraphicalEditPart)selectionElement;
                    element = editPart.resolveSemanticElement();
                    SearchUtils.checkAndAdd(element, result);
                    continue;
                }
                if (selectionElement instanceof IFile) {
                    IFile iFile = (IFile)selectionElement;
                    if (SearchUtils.isOpen(iFile)) {
                        Resource resource = DiagramPartitioningUtil.getSharedDomain().getResourceSet().getResource(URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true), true);
                        EObject statechart = (EObject)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SGraphPackage.Literals.STATECHART);
                        SearchUtils.checkAndAdd(statechart, result);
                        continue;
                    }
                    try {
                        SearchUtils.checkAndAdd((EObject)ResourceUtil.loadStatechart((String)iFile.getFullPath().toOSString()), result);
                    }
                    catch (Exception resource) {}
                    continue;
                }
                if (!(selectionElement instanceof PlatformObject)) continue;
                PlatformObject navItem = (PlatformObject)selectionElement;
                element = (EObject)navItem.getAdapter(EObject.class);
                SearchUtils.checkAndAdd(element, result);
            }
        }
        return result;
    }

    public static List<Resource> getResources(IProject project) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = project.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                result.addAll(SearchUtils.getResources(resource));
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<Resource> getResources(IResource resource) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        try {
            if (resource instanceof IFolder) {
                IResource[] folderMembers;
                IResource[] iResourceArray = folderMembers = ((IFolder)resource).members();
                int n = folderMembers.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource folderMember = iResourceArray[n2];
                    result.addAll(SearchUtils.getResources(folderMember));
                    ++n2;
                }
            } else if (resource instanceof IFile) {
                IFile iFile = (IFile)resource;
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
                IPath path = iFile.getFullPath();
                if (desc == null) {
                    return result;
                }
                if (!desc.getId().equals("org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor")) {
                    return result;
                }
                if (SearchUtils.isOpen(iFile)) {
                    Resource statechartRessource = DiagramPartitioningUtil.getSharedDomain().getResourceSet().getResource(URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true), true);
                    result.add(statechartRessource);
                } else {
                    result.add(ResourceUtil.loadResource((String)path.toOSString()));
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<Resource> getResources(ISelection selection) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        List<EObject> elements = SearchUtils.getModelElement(selection);
        for (EObject element : elements) {
            if (!element.eIsProxy()) {
                result.add(element.eResource());
                continue;
            }
            result.add(EcoreUtil.resolve((EObject)element, (ResourceSet)DiagramPartitioningUtil.getSharedDomain().getResourceSet()).eResource());
        }
        return result;
    }

    public static List<Resource> getResources(IWorkspace workspace) {
        IProject[] projects;
        ArrayList<Resource> result = new ArrayList<Resource>();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            result.addAll(SearchUtils.getResources(project));
            ++n2;
        }
        return result;
    }

    private static boolean isOpen(IFile iFile) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
        if (workbenchWindows.length == 0) {
            return false;
        }
        int i = 0;
        while (i < workbenchWindows.length) {
            IWorkbenchPage[] pages = workbenchWindows[i].getPages();
            if (workbenchWindows.length == 0) {
                return false;
            }
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] ref = pages[j].findEditors((IEditorInput)new FileEditorInput(iFile), "org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor", 1);
                if (ref.length != 0) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

