/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.hmr;

import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.resource.ResourceUtil;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugElement;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sct.simulation.core.hmr.IHotModelReplacementListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class SCTHotModelReplacementManager
implements IResourceChangeListener,
IResourceDeltaVisitor,
ILaunchListener,
IDebugEventSetListener {
    public static final SCTHotModelReplacementManager INSTANCE = new SCTHotModelReplacementManager();
    private List<IDebugTarget> activeTargets;
    private List<IHotModelReplacementListener> listeners;
    private List<IFile> changedFiles = new ArrayList<IFile>();

    private SCTHotModelReplacementManager() {
        this.activeTargets = new ArrayList<IDebugTarget>();
        this.listeners = new ArrayList<IHotModelReplacementListener>();
    }

    public synchronized void addReplacementListener(IHotModelReplacementListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeReplacementListener(IHotModelReplacementListener listener) {
        this.listeners.remove(listener);
    }

    public void startup() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void tearDown() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Object adapter;
            Object source;
            DebugEvent debugEvent = debugEventArray[n2];
            if (debugEvent.getKind() == 8 && (source = debugEvent.getSource()) instanceof IAdaptable && (adapter = ((IAdaptable)source).getAdapter(IDebugTarget.class)) instanceof SCTDebugTarget) {
                this.unregisterSCTTarget((SCTDebugTarget)((Object)adapter));
            }
            ++n2;
        }
    }

    public void launchRemoved(ILaunch launch) {
        IDebugTarget[] debugTargets;
        IDebugTarget[] iDebugTargetArray = debugTargets = launch.getDebugTargets();
        int n = debugTargets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget debugTarget = iDebugTargetArray[n2];
            if (debugTarget instanceof SCTDebugTarget) {
                this.unregisterSCTTarget((SCTDebugTarget)debugTarget);
            }
            ++n2;
        }
    }

    public void launchAdded(ILaunch launch) {
        IDebugTarget[] debugTargets;
        IDebugTarget[] iDebugTargetArray = debugTargets = launch.getDebugTargets();
        int n = debugTargets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget debugTarget = iDebugTargetArray[n2];
            if (debugTarget instanceof SCTDebugTarget) {
                this.registerSCTTarget((SCTDebugTarget)debugTarget);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSCTTarget(SCTDebugTarget target) {
        SCTHotModelReplacementManager sCTHotModelReplacementManager = this;
        synchronized (sCTHotModelReplacementManager) {
            if (this.activeTargets.isEmpty()) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            }
            if (!this.activeTargets.contains((Object)target)) {
                this.activeTargets.add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSCTTarget(SCTDebugTarget target) {
        SCTHotModelReplacementManager sCTHotModelReplacementManager = this;
        synchronized (sCTHotModelReplacementManager) {
            if (this.activeTargets.contains((Object)target)) {
                this.activeTargets.remove((Object)target);
            }
            if (this.activeTargets.isEmpty()) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    public void launchChanged(ILaunch launch) {
        this.launchAdded(launch);
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            this.handleCloseEvent(event);
        }
        IResourceDelta delta = event.getDelta();
        try {
            this.changedFiles.clear();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
            if (this.changedFiles.size() > 0) {
                this.handleHotModelReplacement();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void handleCloseEvent(IResourceChangeEvent event) {
        if (event.getResource() instanceof IProject) {
            IProject project = (IProject)event.getResource();
            for (IDebugTarget target : this.activeTargets) {
                EObject object = (EObject)target.getAdapter(EObject.class);
                IFile file = WorkspaceSynchronizer.getFile((Resource)object.eResource());
                if (!project.equals((Object)file.getProject())) continue;
                try {
                    target.terminate();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleHotModelReplacement() {
        List<IDebugTarget> targets = this.getAffectedTargets();
        ArrayList<IDebugTarget> modelReplacementFailedTargets = new ArrayList<IDebugTarget>();
        for (IDebugTarget sctDebugTarget : targets) {
            Statechart newStatechart = ResourceUtil.loadStatechart((String)((SCTDebugElement)sctDebugTarget).getResourceString());
            if (EcoreUtil.equals((EObject)newStatechart, (EObject)((EObject)sctDebugTarget.getAdapter(EObject.class)))) continue;
            modelReplacementFailedTargets.add(sctDebugTarget);
        }
        if (modelReplacementFailedTargets.size() > 0) {
            this.notifyHotModelReplacementFailed(targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyHotModelReplacementFailed(List<IDebugTarget> affectedTargets) {
        List<IHotModelReplacementListener> list = this.listeners;
        synchronized (list) {
            for (IHotModelReplacementListener listener : this.listeners) {
                listener.hotCodeReplaceFailed(affectedTargets);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IDebugTarget> getAffectedTargets() {
        ArrayList<IDebugTarget> targets = new ArrayList<IDebugTarget>();
        List<IDebugTarget> list = this.activeTargets;
        synchronized (list) {
            for (IDebugTarget debugTarget : this.activeTargets) {
                if (!(debugTarget instanceof SCTDebugTarget)) continue;
                String resourceString = ((SCTDebugElement)debugTarget).getResourceString();
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourceString);
                if (resource == null) {
                    try {
                        debugTarget.terminate();
                    }
                    catch (DebugException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.changedFiles.contains(resource)) continue;
                targets.add(debugTarget);
            }
        }
        return targets;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if ((delta.getKind() == 4 || delta.getKind() == 2) && resource.getType() == 1) {
            IFile file = (IFile)resource;
            this.changedFiles.add(file);
        }
        return true;
    }
}

