/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences.providers;

import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxHostid;
import com.xformation.lmx.LmxLicenseType;
import com.yakindu.licmgmt.internal.LicenseVersion;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class LicenseDetailsContentProvider
implements IStructuredContentProvider {
    private final String MAINTENANCE_START_KEY = "Maintenance Start";
    private final String MAINTENANCE_END_KEY = "Maintenance End";
    private final String COMMENT_KEY = "Comment";
    private final String EXPIRATION_DATE_KEY = "Expiration Date";
    private final String PRODUCT_VERSION_KEY = "Product Version";
    private final String LICENSE_VERSION_KEY = "License Version";
    private final String NODE_LOCKED_KEY = "Node-Locked";
    private final String LOCATION_KEY = "Location";
    private final String CONTACT_INFO_KEY = "Contact Info";
    private final String STATUS_KEY = "Status";
    private final String LICENSE_TYPE_KEY = "License Type";
    private final String FEATURE_ID = "Feature ID";

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        TableItemData currentlySelectedItem = (TableItemData)inputElement;
        AbstractLicenseFeature activeLicenseFeature = currentlySelectedItem.getLicenseFeature();
        LmxFeatureInfo activeLicenseFeatureInfo = currentlySelectedItem.getFeatureInfo();
        LinkedHashMap<String, String> licenseDetailsMap = new LinkedHashMap<String, String>();
        this.fillLicenseDetailsMap(activeLicenseFeatureInfo, currentlySelectedItem, activeLicenseFeature, licenseDetailsMap);
        return licenseDetailsMap.entrySet().toArray();
    }

    private void fillLicenseDetailsMap(LmxFeatureInfo activeLicFeatureInfo, TableItemData currentlySelectedItem, AbstractLicenseFeature activeLicenseFeature, Map<String, String> map) {
        map.put("Feature ID", activeLicenseFeature.getLicenseFeatureId());
        map.put("License Type", activeLicFeatureInfo != null ? this.mapLmxLicTypeToUserReadableString(activeLicFeatureInfo) : null);
        String statusMessage = currentlySelectedItem.getLicenseManager().getStatusMessage();
        if (statusMessage != null && !statusMessage.isEmpty()) {
            map.put("Status", statusMessage);
        }
        map.put("Expiration Date", this.getExpirationDate(activeLicFeatureInfo));
        map.put("Maintenance Start", this.getFeatureField(activeLicFeatureInfo, LmxFeatureInfo::getMaintenanceStartDate));
        map.put("Maintenance End", this.getFeatureField(activeLicFeatureInfo, LmxFeatureInfo::getMaintenanceEndDate));
        map.put("Product Version", activeLicenseFeature.getMinimalRequiredLicenseVersion());
        map.put("License Version", this.getFeatureField(activeLicFeatureInfo, f -> new LicenseVersion(f.getMajorVer(), f.getMinorVer()).getVersionString()));
        map.put("Location", this.getFeatureField(activeLicFeatureInfo, LmxFeatureInfo::getPath));
        map.put("Node-Locked", this.getHostIdText(activeLicFeatureInfo));
        map.put("Comment", this.getFeatureField(activeLicFeatureInfo, LmxFeatureInfo::getComment));
        map.put("Contact Info", activeLicenseFeature.getFeatureUrl());
        this.removeEntriesWithEmptyValues(map);
        map.replace("Location", "Securestore", "Internal");
    }

    private String mapLmxLicTypeToUserReadableString(LmxFeatureInfo activeLicFeatureInfo) {
        switch (activeLicFeatureInfo.getLicenseType()) {
            case LMX_TYPE_BORROW: {
                return "Borrowable";
            }
            case LMX_TYPE_LOCAL: {
                return "Local";
            }
            case LMX_TYPE_TRIAL: {
                return "Trial";
            }
            case LMX_TYPE_NETWORK: {
                return "Floating";
            }
        }
        throw new IllegalStateException("At the moment, we use only the above license types.");
    }

    private void removeEntriesWithEmptyValues(Map<String, String> map) {
        map.entrySet().removeIf(e -> e.getValue() == null || ((String)e.getValue()).trim().isEmpty());
    }

    private String getExpirationDate(LmxFeatureInfo activeLicFeatureInfo) {
        return this.getFeatureField(activeLicFeatureInfo, f -> {
            String endDate = f.getEndDate();
            String endDateOrPermanent = endDate == null || endDate.trim().isEmpty() ? "permanent" : endDate;
            String expireDate = f.getActualExpireTime();
            if (LmxLicenseType.LMX_TYPE_TRIAL.equals((Object)f.getLicenseType())) {
                return expireDate;
            }
            if (LmxLicenseType.LMX_TYPE_BORROW.equals((Object)f.getLicenseType())) {
                return String.valueOf(endDateOrPermanent) + " (borrowed until " + expireDate + ")";
            }
            if (LmxLicenseType.LMX_TYPE_GRACE.equals((Object)f.getLicenseType())) {
                return String.valueOf(endDateOrPermanent) + " (grace period until " + expireDate + ")";
            }
            return endDateOrPermanent;
        });
    }

    private String getHostIdText(LmxFeatureInfo licenseInfo) {
        return this.getFeatureField(licenseInfo, f -> {
            List hostIds = f.getClientLicenseHostid();
            return hostIds == null || hostIds.isEmpty() ? null : "Host-ID: " + hostIds.stream().map(LmxHostid::getValue).collect(Collectors.joining(", "));
        });
    }

    private String getFeatureField(LmxFeatureInfo activeLicenseFeatureInfo, Function<LmxFeatureInfo, String> getter) {
        if (activeLicenseFeatureInfo == null) {
            return null;
        }
        String value = getter.apply(activeLicenseFeatureInfo);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }
}

