/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.extension;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.DomainElement;
import com.yakindu.sct.domain.extension.DomainStatus;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.domain.extension.IDomainDocumentationProvider;
import com.yakindu.sct.domain.extension.IDomainStatusProvider;
import com.yakindu.sct.domain.extension.IModuleProvider;
import com.yakindu.sct.domain.extension.impl.DomainImpl;
import com.yakindu.sct.domain.extension.impl.ModuleContribution;
import com.yakindu.sct.model.sgraph.resource.FastStatechartAttributeParser;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.EcoreUtil2;
import org.osgi.framework.Bundle;

public class DomainRegistry {
    private static final String DOMAIN_EXTENSION_POINT_ID = "com.yakindu.sct.domain";
    private static final String MODULES_EXTENSION_POINT_ID = "com.yakindu.sct.domain.modules";
    public static final String DOMAIN_ID = "domainID";
    private static final String DESCRIPTION = "description";
    private static final String IMAGE = "image";
    private static final String NAME = "name";
    private static final String DOMAIN_STATUS_PROVIDER = "domainStatusProvider";
    private static final String DOCU_PROVIDER = "documentationProvider";
    private static final String FEATURE = "feature";
    private static final String MODULE_PROVIDER = "moduleProvider";
    private static List<IDomain> domainDescriptors;

    private DomainRegistry() {
    }

    public static synchronized List<IDomain> getDomains() {
        if (domainDescriptors == null) {
            domainDescriptors = Lists.newArrayList();
            DomainRegistry.initFromExtensions();
        }
        return domainDescriptors;
    }

    public static IDomain getDomain(final String id) {
        final String defaultDomainID = BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
        try {
            return (IDomain)Iterables.find(DomainRegistry.getDomains(), (Predicate)new Predicate<IDomain>(){

                public boolean apply(IDomain input) {
                    return input.getDomainID().equals(id != null ? id : defaultDomainID);
                }
            });
        }
        catch (NoSuchElementException e) {
            if (defaultDomainID.equals(id)) {
                return null;
            }
            return DomainRegistry.getDomain(defaultDomainID);
        }
    }

    public static IDomain getDomain(EObject object) {
        DomainElement domainElement = (DomainElement)EcoreUtil2.getContainerOfType((EObject)object, DomainElement.class);
        String domainID = domainElement != null ? domainElement.getDomainID() : BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
        return DomainRegistry.getDomain(domainID);
    }

    public static boolean domainExists(final String domainID) {
        try {
            Iterables.find(DomainRegistry.getDomains(), (Predicate)new Predicate<IDomain>(){

                public boolean apply(IDomain input) {
                    return input.getDomainID().equals(domainID == null || domainID.isEmpty() ? BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral() : domainID);
                }
            });
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public static String determineDomainID(URI uri) {
        Optional domainID;
        if (URIConverter.INSTANCE.exists(uri, null) && (domainID = FastStatechartAttributeParser.parse((URI)uri, (String)DOMAIN_ID)).isPresent()) {
            return (String)domainID.get();
        }
        return BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
    }

    public static DomainStatus getDomainStatus(String domainID) {
        if (!DomainRegistry.domainExists(domainID)) {
            return new DomainStatus(DomainStatus.Severity.ERROR, String.format(String.format("Domain '%s' is not available.", domainID), new Object[0]));
        }
        IDomain domain = DomainRegistry.getDomain(domainID);
        return domain.getAvailabilityStatus();
    }

    protected static void initFromExtensions() {
        IConfigurationElement[] configurationElements;
        ArrayList<ModuleContribution> moduleDescriptors = new ArrayList<ModuleContribution>();
        if (!Platform.isRunning()) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(MODULES_EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            moduleDescriptors.add(DomainRegistry.createModuleContribution(element));
            ++n2;
        }
        iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(DOMAIN_EXTENSION_POINT_ID);
        n = configurationElements.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            domainDescriptors.add(DomainRegistry.createDomain(iConfigurationElement, moduleDescriptors));
            ++n2;
        }
    }

    protected static ModuleContribution createModuleContribution(IConfigurationElement element) {
        ModuleProviderProxy provider = new ModuleProviderProxy(element);
        return new ModuleContribution(element.getAttribute(DOMAIN_ID), element.getAttribute(FEATURE), provider);
    }

    protected static IDomain createDomain(final IConfigurationElement element, List<ModuleContribution> allModules) {
        String path = element.getAttribute(IMAGE);
        URL image = null;
        if (path != null) {
            Bundle extensionBundle = Platform.getBundle((String)element.getContributor().getName());
            image = extensionBundle.getEntry(path);
        }
        IDomainStatusProvider statusProvider = new IDomainStatusProvider.DefaultDomainStatusProvider();
        if (element.getAttribute(DOMAIN_STATUS_PROVIDER) != null) {
            try {
                statusProvider = (IDomainStatusProvider)element.createExecutableExtension(DOMAIN_STATUS_PROVIDER);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        IDomainDocumentationProvider docuProvider = new IDomainDocumentationProvider.NullImpl();
        if (element.getAttribute(DOCU_PROVIDER) != null) {
            try {
                docuProvider = (IDomainDocumentationProvider)element.createExecutableExtension(DOCU_PROVIDER);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return new DomainImpl(element.getAttribute(DOMAIN_ID), element.getAttribute(NAME), element.getAttribute(DESCRIPTION), image, Iterables.filter(allModules, (Predicate)new Predicate<ModuleContribution>(){

            public boolean apply(ModuleContribution input) {
                return input.getDomainID().equals(element.getAttribute(DomainRegistry.DOMAIN_ID));
            }
        }), statusProvider, docuProvider);
    }

    protected static class ModuleProviderProxy
    implements IModuleProvider {
        private IConfigurationElement element;
        private IModuleProvider provider;

        public ModuleProviderProxy(IConfigurationElement element) {
            this.element = element;
        }

        @Override
        public Module getModule(String ... options) throws IllegalArgumentException {
            if (this.provider == null) {
                try {
                    this.provider = (IModuleProvider)this.element.createExecutableExtension(DomainRegistry.MODULE_PROVIDER);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return new Module(){

                        public void configure(Binder binder) {
                        }
                    };
                }
            }
            return this.provider.getModule(options);
        }
    }
}

