/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.validation;

import com.yakindu.base.base.DomainElement;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.DomainStatus;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;

public class DomainValidator
implements EValidator {
    public static final String MSG_DOMAIN_UNAVAILABLE = "Domain '%s' not found!";
    public static final String CODE_DOMAIN_UNAVAILABLE = "DomainUnavailable";

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eObject instanceof DomainElement) {
            DomainStatus status = DomainRegistry.getDomainStatus(((DomainElement)eObject).getDomainID());
            if (status.getSeverity() == DomainStatus.Severity.ERROR) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "DomainValidator", 0, status.getShortMessage(), new Object[]{eObject}));
            } else if (status.getSeverity() == DomainStatus.Severity.WARNING) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "DomainValidator", 0, status.getMessage(), new Object[]{eObject}));
            } else if (status.getSeverity() == DomainStatus.Severity.INFO) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "DomainValidator", 0, status.getShortMessage(), new Object[]{eObject}));
            }
        }
        return true;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }
}

