/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.terminals;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class HexValueConverter
extends AbstractLexerBasedConverter<Long> {
    public static final String HEX_PREFIX = "0x";

    public Long toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to number.", node, null);
        }
        try {
            return Long.parseLong(string.substring(2), 16);
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to number.", node, null);
        }
    }

    protected String toEscapedString(Long value) {
        if (value < 0L) {
            return "-0x" + Long.toString(value * -1L, 16).toUpperCase();
        }
        return HEX_PREFIX + Long.toString(value, 16).toUpperCase();
    }
}

