/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.debugging;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yakindu.base.expressions.ExpressionsRuntimeModule;
import com.yakindu.base.expressions.expressions.Guard;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.base.types.Expression;
import com.yakindu.base.xtext.utils.jface.viewers.context.XtextFakeResourceContext;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sexec.Trace;
import com.yakindu.sct.model.sexec.TraceEndRunCycle;
import com.yakindu.sct.model.sexec.TraceReactionWillFire;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.sexec.interpreter.DefaultTraceStepInterpreter;
import com.yakindu.sct.simulation.core.sexec.interpreter.ITraceStepInterpreter;
import com.yakindu.sct.simulation.debugging.ISCTBreakpoint;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.StringInputStream;

public class BreakpointTraceStepEvaluator
extends DefaultTraceStepInterpreter
implements ITraceStepInterpreter {
    @Inject
    private IExpressionInterpreter interpreter;
    @Inject
    ILaunch launch;
    private boolean shouldSuspendForState = false;

    private XtextResource createFakeResource(EObject objectcontext) {
        XtextFakeResourceContext context;
        IDomain domain = DomainRegistry.getDomain((EObject)objectcontext);
        if (domain != null) {
            Injector injector = domain.getInjector("com.yakindu.sct.editor", new String[]{Guard.class.getName()});
            context = new XtextFakeResourceContext(injector);
        } else {
            context = new XtextFakeResourceContext(Guice.createInjector((Module[])new Module[]{new ExpressionsRuntimeModule()}));
        }
        XtextResource fakeResource = context.getFakeResource();
        EObject contextElement = (EObject)this.launch.getDebugTarget().getAdapter(EObject.class);
        fakeResource.eAdapters().add((Object)new ContextElementAdapter(contextElement));
        return fakeResource;
    }

    public void evaluate(Trace trace, ExecutionContext context) {
        if (!"debug".equals(this.launch.getLaunchMode())) {
            return;
        }
        if (!this.launch.getDebugTarget().isSuspended()) {
            if (trace instanceof TraceReactionWillFire) {
                EObject element = ((TraceReactionWillFire)trace).getReaction().getSourceElement();
                if (element instanceof Transition) {
                    this.evaluateBreakpoint(context, element);
                    this.shouldSuspendForState = false;
                }
            } else if (trace instanceof TraceEndRunCycle && !this.shouldSuspendForState) {
                this.checkBreakpoints(context);
            }
            super.evaluate(trace, context);
        }
    }

    protected void evaluateBreakpoint(ExecutionContext context, EObject element) {
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        try {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.yakindu.sct.simulation.core.sct.breakpoints");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                ISCTBreakpoint sctBreakpoint;
                IBreakpoint iBreakpoint = iBreakpointArray[n2];
                if (iBreakpoint.isEnabled() && iBreakpoint instanceof ISCTBreakpoint && EcoreUtil.getURI((EObject)(sctBreakpoint = (ISCTBreakpoint)iBreakpoint).resolveSemanticElement()).equals(EcoreUtil.getURI((EObject)element))) {
                    Expression statement;
                    if (((ISCTBreakpoint)iBreakpoint).isConditional() && (statement = this.getStatement(sctBreakpoint.resolveSemanticElement(), sctBreakpoint.getExpression())) != null) {
                        Object result = this.interpreter.evaluate(statement, (ExecutionContext)EcoreUtil.copy((EObject)context));
                        if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                            this.suspend(element, context);
                        }
                    } else {
                        this.suspend(element, context);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private void suspend(EObject object, ExecutionContext context) {
        try {
            this.launch.getDebugTarget().suspend();
            context.getSuspendedElements().add(object);
            this.shouldSuspendForState = !this.shouldSuspendForState && object instanceof State;
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    protected Expression getStatement(EObject context, String condition) {
        EObject rootASTElement;
        block3: {
            try {
                XtextResource fakeResource = this.createFakeResource(context);
                fakeResource.load((InputStream)new StringInputStream(""), Collections.emptyMap());
                fakeResource.reparse(condition);
                rootASTElement = fakeResource.getParseResult().getRootASTElement();
                if (!fakeResource.getParseResult().hasSyntaxErrors() && fakeResource.getErrors().size() <= 0) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return ((Guard)rootASTElement).getExpression();
    }

    protected void checkBreakpoints(ExecutionContext context) {
        context.getActiveStates().forEach(s -> {
            if (s instanceof State) {
                this.evaluateBreakpoint(context, (EObject)((State)s));
            }
        });
    }
}

