/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.builder.efs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.OutputConfiguration;

@Singleton
public class SCTEclipseResourceFileSystemAccess
extends EclipseResourceFileSystemAccess2
implements ISCTFileSystemAccess {
    @Inject
    private IWorkspace ws;

    public SCTEclipseResourceFileSystemAccess() {
        this.setMonitor((IProgressMonitor)new NullProgressMonitor());
    }

    public void setContext(String projectName) {
        IProject project = this.ws.getRoot().getProject(projectName);
        super.setProject(project);
    }

    public URI getURI(String path, String outputConfiguration) {
        OutputConfiguration outputConfig = this.getOutputConfig(outputConfiguration);
        String outputDir = outputConfig.getOutputDirectory();
        if (this.isRootPath(outputDir) && this.isRootPath(path)) {
            return URI.createFileURI((String)this.getProject().getLocationURI().getPath());
        }
        IFile file = this.getProject().getFile(outputDir + File.separator + path);
        if (file != null) {
            return URI.createFileURI((String)file.getLocationURI().getPath());
        }
        return super.getURI(path);
    }

    protected boolean isRootPath(String path) {
        return ".".equals(path) || "/".equals(path) || "./".equals(path) || "".equals(path);
    }
}

