/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.json.transformation.json2xmi;

import com.google.common.collect.Iterables;
import com.yakindu.sct.json.transformation.model.JsonCell;
import com.yakindu.sct.json.transformation.model.JsonChoice;
import com.yakindu.sct.json.transformation.model.JsonEntry;
import com.yakindu.sct.json.transformation.model.JsonExit;
import com.yakindu.sct.json.transformation.model.JsonFinal;
import com.yakindu.sct.json.transformation.model.JsonGraph;
import com.yakindu.sct.json.transformation.model.JsonRegion;
import com.yakindu.sct.json.transformation.model.JsonRoot;
import com.yakindu.sct.json.transformation.model.JsonState;
import com.yakindu.sct.json.transformation.model.JsonStatechart;
import com.yakindu.sct.json.transformation.model.JsonSynchronization;
import com.yakindu.sct.json.transformation.model.JsonTransition;
import com.yakindu.sct.json.transformation.model.JsonTransitionAnchor;
import com.yakindu.sct.json.transformation.model.JsonTransitionSource;
import com.yakindu.sct.json.transformation.model.JsonTransitionTarget;
import com.yakindu.sct.json.transformation.model.util.NodeModelFactory;
import com.yakindu.sct.json.transformation.model.util.NotationUtil;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.ChoiceKind;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.EntryKind;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.SGraphFactory;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JSONToXMITransformation {
    @Extension
    private SGraphFactory _sGraphFactory = SGraphFactory.eINSTANCE;
    @Extension
    private NotationFactory _notationFactory = NotationFactory.eINSTANCE;
    @Extension
    private NotationUtil _notationUtil = new NotationUtil();
    @Extension
    private NodeModelFactory _nodeModelFactory = new NodeModelFactory();
    private Map<String, Vertex> vertexMap = new HashMap<String, Vertex>();
    private Map<String, Node> nodeMap = new HashMap<String, Node>();

    public Resource transform(JsonRoot root) {
        boolean _greaterThan;
        GMFResource _xblockexpression = null;
        this.vertexMap.clear();
        this.nodeMap.clear();
        URI _createFileURI = URI.createFileURI((String)"dummy.sct");
        GMFResource resource = new GMFResource(_createFileURI);
        JsonStatechart jsonStatechart = root.getGraph().findStatechart();
        Diagram _createDiagram = this._notationFactory.createDiagram();
        Procedures.Procedure1 _function = it -> {
            it.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
            it.setType("itemis.create.ui.editor.editor.StatechartDiagramEditor");
            EList _styles = it.getStyles();
            BooleanValueStyle _createBooleanValueStyle = this._notationFactory.createBooleanValueStyle();
            Procedures.Procedure1 _function_1 = it_1 -> it_1.setName("inlineDefinitionSection");
            BooleanValueStyle _doubleArrow = (BooleanValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createBooleanValueStyle, (Procedures.Procedure1)_function_1);
            _styles.add((Object)_doubleArrow);
        };
        Diagram diagram = (Diagram)ObjectExtensions.operator_doubleArrow((Object)_createDiagram, (Procedures.Procedure1)_function);
        Statechart _createStatechart = this._sGraphFactory.createStatechart();
        Procedures.Procedure1 _function_1 = it -> {
            it.setName(jsonStatechart.getName());
            it.setSpecification(jsonStatechart.getSpecification());
            EList _regions = it.getRegions();
            Functions.Function1 _function_2 = it_1 -> this.transformElement(root.getGraph(), (JsonCell)it_1, (View)diagram);
            Iterable _filter = Iterables.filter((Iterable)ListExtensions.map(root.getGraph().findTopLevelRegions(), (Functions.Function1)_function_2), Region.class);
            Iterables.addAll((Collection)_regions, (Iterable)_filter);
        };
        Statechart statechart = (Statechart)ObjectExtensions.operator_doubleArrow((Object)_createStatechart, (Procedures.Procedure1)_function_1);
        List<JsonCell> verticesWithoutRegion = root.getGraph().findTopLevelVertices();
        int _size = verticesWithoutRegion.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Region _createRegion = this._sGraphFactory.createRegion();
            Procedures.Procedure1 _function_2 = it -> {
                it.setName("main");
                EList _vertices = it.getVertices();
                Functions.Function1 _function_3 = it_1 -> this.transformElement(root.getGraph(), (JsonCell)it_1, (View)diagram);
                Iterable _filter = Iterables.filter((Iterable)ListExtensions.map((List)verticesWithoutRegion, (Functions.Function1)_function_3), Vertex.class);
                Iterables.addAll((Collection)_vertices, (Iterable)_filter);
            };
            Region topLevelRegion = (Region)ObjectExtensions.operator_doubleArrow((Object)_createRegion, (Procedures.Procedure1)_function_2);
            Node regionShape = this._nodeModelFactory.createRegionNode(topLevelRegion);
            diagram.insertChild((View)regionShape);
            EList _regions = statechart.getRegions();
            _regions.add((Object)topLevelRegion);
        }
        Consumer<JsonTransition> _function_3 = it -> this.transformElement(root.getGraph(), (JsonCell)it, (View)diagram);
        Iterables.filter(root.getGraph().getCells(), JsonTransition.class).forEach(_function_3);
        diagram.setElement((EObject)statechart);
        EList _contents = resource.getContents();
        _contents.add((Object)statechart);
        EList _contents_1 = resource.getContents();
        _contents_1.add((Object)diagram);
        _xblockexpression = resource;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonState jsonState, View container) {
        State _xblockexpression = null;
        State _createState = this._sGraphFactory.createState();
        Procedures.Procedure1 _function = it -> {
            it.setName(jsonState.getName());
            it.setSpecification(jsonState.getSpecification());
        };
        State state = (State)ObjectExtensions.operator_doubleArrow((Object)_createState, (Procedures.Procedure1)_function);
        this.vertexMap.put(jsonState.getId(), (Vertex)state);
        Node shape = this._nodeModelFactory.createStateNode(state);
        shape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(graph, jsonState));
        this.nodeMap.put(jsonState.getId(), shape);
        container.insertChild((View)shape);
        Functions.Function1 _function_1 = it -> {
            String _type = it.getType();
            return Objects.equals(_type, "StateFigureCompartment");
        };
        View compartmentNode = (View)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)shape.getChildren(), View.class), (Functions.Function1)_function_1);
        Iterable children = Iterables.filter(graph.findChildren(jsonState), JsonRegion.class);
        Functions.Function1 _function_2 = child -> this.transformElement(graph, (JsonCell)child, compartmentNode);
        Iterable regions = Iterables.filter((Iterable)IterableExtensions.map((Iterable)children, (Functions.Function1)_function_2), Region.class);
        EList _regions = state.getRegions();
        Iterables.addAll((Collection)_regions, (Iterable)regions);
        _xblockexpression = state;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonRegion jsonRegion, View container) {
        Region _xblockexpression = null;
        Region _createRegion = this._sGraphFactory.createRegion();
        Procedures.Procedure1 _function = it -> it.setName(jsonRegion.getName());
        Region region = (Region)ObjectExtensions.operator_doubleArrow((Object)_createRegion, (Procedures.Procedure1)_function);
        Node shape = this._nodeModelFactory.createRegionNode(region);
        Bounds _relativeBounds = this._notationUtil.toRelativeBounds(graph, jsonRegion);
        Procedures.Procedure1 _function_1 = it -> {
            it.setWidth(it.getWidth());
            int _height = it.getHeight();
            int _plus = _height + 20;
            it.setHeight(_plus);
        };
        Bounds _doubleArrow = (Bounds)ObjectExtensions.operator_doubleArrow((Object)_relativeBounds, (Procedures.Procedure1)_function_1);
        shape.setLayoutConstraint((LayoutConstraint)_doubleArrow);
        container.insertChild((View)shape);
        Functions.Function1 _function_2 = it -> {
            String _type = it.getType();
            return Objects.equals(_type, "RegionCompartment");
        };
        View compartmentNode = (View)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)shape.getChildren(), View.class), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> !(it instanceof JsonTransition);
        Iterable children = IterableExtensions.filter(graph.findChildren(jsonRegion), (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = child -> this.transformElement(graph, (JsonCell)child, compartmentNode);
        Iterable vertices = Iterables.filter((Iterable)IterableExtensions.map((Iterable)children, (Functions.Function1)_function_4), Vertex.class);
        EList _vertices = region.getVertices();
        Iterables.addAll((Collection)_vertices, (Iterable)vertices);
        _xblockexpression = region;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonEntry jsonEntry, View container) {
        Entry _xblockexpression = null;
        Entry _createEntry = this._sGraphFactory.createEntry();
        Procedures.Procedure1 _function = it -> {
            it.setName(graph.findNodeLabel(jsonEntry).getName());
            it.setKind(EntryKind.get((String)jsonEntry.getEntryKind()));
        };
        Entry entry = (Entry)ObjectExtensions.operator_doubleArrow((Object)_createEntry, (Procedures.Procedure1)_function);
        this.vertexMap.put(jsonEntry.getId(), (Vertex)entry);
        Node entryShape = this._nodeModelFactory.createEntryNode(entry);
        entryShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(graph, jsonEntry));
        this.nodeMap.put(jsonEntry.getId(), entryShape);
        container.insertChild((View)entryShape);
        _xblockexpression = entry;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonExit jsonExit, View container) {
        Exit _xblockexpression = null;
        Exit _createExit = this._sGraphFactory.createExit();
        Procedures.Procedure1 _function = it -> it.setName(graph.findNodeLabel(jsonExit).getName());
        Exit exit = (Exit)ObjectExtensions.operator_doubleArrow((Object)_createExit, (Procedures.Procedure1)_function);
        this.vertexMap.put(jsonExit.getId(), (Vertex)exit);
        Node exitShape = this._nodeModelFactory.createExitNode(exit);
        exitShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(graph, jsonExit));
        this.nodeMap.put(jsonExit.getId(), exitShape);
        container.insertChild((View)exitShape);
        _xblockexpression = exit;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonFinal jsonFinal, View container) {
        FinalState _xblockexpression = null;
        FinalState _createFinalState = this._sGraphFactory.createFinalState();
        Procedures.Procedure1 _function = it -> it.setName(jsonFinal.getName());
        FinalState finalState = (FinalState)ObjectExtensions.operator_doubleArrow((Object)_createFinalState, (Procedures.Procedure1)_function);
        this.vertexMap.put(jsonFinal.getId(), (Vertex)finalState);
        Node finalShape = this._nodeModelFactory.createFinalNode(finalState);
        finalShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(graph, jsonFinal));
        this.nodeMap.put(jsonFinal.getId(), finalShape);
        container.insertChild((View)finalShape);
        _xblockexpression = finalState;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonChoice jsonChoice, View container) {
        Choice _xblockexpression = null;
        Choice _createChoice = this._sGraphFactory.createChoice();
        Procedures.Procedure1 _function = it -> {
            it.setName(jsonChoice.getName());
            it.setKind(ChoiceKind.DYNAMIC);
        };
        Choice choice = (Choice)ObjectExtensions.operator_doubleArrow((Object)_createChoice, (Procedures.Procedure1)_function);
        this.vertexMap.put(jsonChoice.getId(), (Vertex)choice);
        Node choiceShape = this._nodeModelFactory.createChoiceNode(choice);
        choiceShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(graph, jsonChoice));
        this.nodeMap.put(jsonChoice.getId(), choiceShape);
        container.insertChild((View)choiceShape);
        _xblockexpression = choice;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonSynchronization jsonSync, View container) {
        Synchronization _xblockexpression = null;
        Synchronization sync = this._sGraphFactory.createSynchronization();
        this.vertexMap.put(jsonSync.getId(), (Vertex)sync);
        Node syncShape = this._nodeModelFactory.createSynchNode(sync);
        syncShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(graph, jsonSync));
        this.nodeMap.put(jsonSync.getId(), syncShape);
        container.insertChild((View)syncShape);
        _xblockexpression = sync;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonGraph graph, JsonTransition jsonTransition, View container) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Transition _xblockexpression = null;
        Transition _createTransition = this._sGraphFactory.createTransition();
        Procedures.Procedure1 _function = it -> {
            it.setSpecification(jsonTransition.getSpecification());
            it.setSource(this.vertexMap.get(jsonTransition.getSourceId()));
            it.setTarget(this.vertexMap.get(jsonTransition.getTargetId()));
        };
        Transition transition = (Transition)ObjectExtensions.operator_doubleArrow((Object)_createTransition, (Procedures.Procedure1)_function);
        Edge edge = this._nodeModelFactory.createTransitionEdge(transition);
        edge.setSource((View)this.nodeMap.get(jsonTransition.getSourceId()));
        edge.setTarget((View)this.nodeMap.get(jsonTransition.getTargetId()));
        JsonTransitionSource _source = null;
        if (jsonTransition != null) {
            _source = jsonTransition.getSource();
        }
        JsonTransitionAnchor _anchor = null;
        if (_source != null) {
            _anchor = _source.getAnchor();
        }
        boolean bl = _tripleNotEquals = _anchor != null;
        if (_tripleNotEquals) {
            JsonTransitionSource _source_1 = null;
            if (jsonTransition != null) {
                _source_1 = jsonTransition.getSource();
            }
            JsonTransitionAnchor _anchor_1 = null;
            if (_source_1 != null) {
                _anchor_1 = _source_1.getAnchor();
            }
            edge.setSourceAnchor((Anchor)this._notationUtil.createAnchor(_anchor_1));
        }
        JsonTransitionTarget _target = null;
        if (jsonTransition != null) {
            _target = jsonTransition.getTarget();
        }
        JsonTransitionAnchor _anchor_2 = null;
        if (_target != null) {
            _anchor_2 = _target.getAnchor();
        }
        boolean bl2 = _tripleNotEquals_1 = _anchor_2 != null;
        if (_tripleNotEquals_1) {
            JsonTransitionTarget _target_1 = null;
            if (jsonTransition != null) {
                _target_1 = jsonTransition.getTarget();
            }
            JsonTransitionAnchor _anchor_3 = null;
            if (_target_1 != null) {
                _anchor_3 = _target_1.getAnchor();
            }
            edge.setTargetAnchor((Anchor)this._notationUtil.createAnchor(_anchor_3));
        }
        DecorationNode _createDecorationNode = this._notationFactory.createDecorationNode();
        Procedures.Procedure1 _function_1 = it -> {
            it.setType("TransitionExpression");
            it.setLayoutConstraint((LayoutConstraint)this._notationUtil.createLabelPosition(jsonTransition));
        };
        DecorationNode _doubleArrow = (DecorationNode)ObjectExtensions.operator_doubleArrow((Object)_createDecorationNode, (Procedures.Procedure1)_function_1);
        edge.insertChild((View)_doubleArrow);
        ((Diagram)container).insertEdge(edge);
        _xblockexpression = transition;
        return _xblockexpression;
    }

    @XbaseGenerated
    protected EObject transformElement(JsonGraph graph, JsonCell jsonChoice, View container) {
        if (jsonChoice instanceof JsonChoice) {
            return this._transformElement(graph, (JsonChoice)jsonChoice, container);
        }
        if (jsonChoice instanceof JsonEntry) {
            return this._transformElement(graph, (JsonEntry)jsonChoice, container);
        }
        if (jsonChoice instanceof JsonExit) {
            return this._transformElement(graph, (JsonExit)jsonChoice, container);
        }
        if (jsonChoice instanceof JsonFinal) {
            return this._transformElement(graph, (JsonFinal)jsonChoice, container);
        }
        if (jsonChoice instanceof JsonRegion) {
            return this._transformElement(graph, (JsonRegion)jsonChoice, container);
        }
        if (jsonChoice instanceof JsonState) {
            return this._transformElement(graph, (JsonState)jsonChoice, container);
        }
        if (jsonChoice instanceof JsonSynchronization) {
            return this._transformElement(graph, (JsonSynchronization)jsonChoice, container);
        }
        if (jsonChoice instanceof JsonTransition) {
            return this._transformElement(graph, (JsonTransition)jsonChoice, container);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(graph, jsonChoice, container).toString());
    }
}

