/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.context;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.TypeCastExpression;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.base.expressions.interpreter.context.IExecutionContextInitializer;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypedElement;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class DefaultExecutionSlotResolver
implements IExecutionSlotResolver {
    @Inject
    @Extension
    protected IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    protected IExpressionInterpreter _iExpressionInterpreter;
    @Inject
    protected ITypeSystem ts;
    @Inject
    protected IExecutionContextInitializer slotInitializer;

    protected Optional<ExecutionSlot> _resolve(ExecutionContext context, FeatureCall e) {
        return Optional.ofNullable(this.resolveByFeature(context, e, e.getFeature()));
    }

    protected Optional<ExecutionSlot> _resolve(ExecutionContext context, ElementReferenceExpression e) {
        ExecutionSlot slot = this.packageNamespaceAwareResolve(context, e.getReference());
        boolean _isArrayAccess = e.isArrayAccess();
        if (_isArrayAccess) {
            EObject _reference = e.getReference();
            slot = this.resolveArrayElement(context, slot, (List<Expression>)e.getArraySelector(), ((TypedElement)_reference).getTypeSpecifier());
        }
        return Optional.ofNullable(slot);
    }

    protected Optional<ExecutionSlot> _resolve(ExecutionContext context, AssignmentExpression e) {
        return this.resolve(context, e.getVarRef());
    }

    protected Optional<ExecutionSlot> _resolve(ExecutionContext context, TypeCastExpression e) {
        return this.resolve(context, e.getOperand());
    }

    protected ExecutionSlot _resolveByFeature(ExecutionContext context, FeatureCall e, EObject feature) {
        return context.getVariable(this._iQualifiedNameProvider.getFullyQualifiedName(e.getFeature()).toString());
    }

    protected ExecutionSlot _resolveByFeature(ExecutionContext context, FeatureCall e, Operation feature) {
        return this.resolveCompositeSlot(context, e);
    }

    protected ExecutionSlot _resolveByFeature(ExecutionContext context, FeatureCall e, Event feature) {
        return this.resolveCompositeSlot(context, e);
    }

    protected ExecutionSlot _resolveByFeature(ExecutionContext context, FeatureCall e, Property feature) {
        return this.resolveCompositeSlot(context, e);
    }

    protected ExecutionSlot resolveCompositeSlot(ExecutionContext context, FeatureCall e) {
        boolean _not;
        Optional<ExecutionSlot> featureSlot = this.resolve(context, e.getOwner());
        boolean _isPresent = featureSlot.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            return null;
        }
        return this.resolveFromSlot(featureSlot.get(), (EObject)e);
    }

    protected ExecutionSlot _resolveFromSlot(ExecutionSlot slot, FeatureCall call) {
        return slot;
    }

    protected ExecutionSlot _resolveFromSlot(CompositeSlot slot, Operation call) {
        return this.resolveByFeature(slot, (EObject)call);
    }

    protected ExecutionSlot _resolveFromSlot(CompositeSlot slot, FeatureCall call) {
        ExecutionSlot resolvedSlot = this.resolveByFeature(slot, call.getFeature());
        boolean _isArrayAccess = call.isArrayAccess();
        if (_isArrayAccess) {
            EObject _feature = call.getFeature();
            resolvedSlot = this.resolveArrayElement((ExecutionContext)EcoreUtil2.getContainerOfType((EObject)resolvedSlot, ExecutionContext.class), resolvedSlot, (List<Expression>)call.getArraySelector(), ((TypedElement)_feature).getTypeSpecifier());
        }
        return resolvedSlot;
    }

    protected ExecutionSlot _resolveFromSlot(ReferenceSlot slot, Operation call) {
        ExecutionSlot _xifexpression = null;
        ExecutionSlot _reference = slot.getReference();
        if (_reference instanceof CompositeSlot) {
            ExecutionSlot _reference_1 = slot.getReference();
            _xifexpression = this.resolveByFeature((CompositeSlot)_reference_1, (EObject)call);
        } else {
            _xifexpression = this.resolveByFeature((CompositeSlot)slot, (EObject)call);
        }
        return _xifexpression;
    }

    protected ExecutionSlot _resolveFromSlot(ReferenceSlot slot, FeatureCall call) {
        ExecutionSlot _xifexpression = null;
        ExecutionSlot _reference = slot.getReference();
        if (_reference instanceof CompositeSlot) {
            ExecutionSlot _reference_1 = slot.getReference();
            _xifexpression = this.resolveByFeature((CompositeSlot)_reference_1, call.getFeature());
        } else {
            _xifexpression = this.resolveByFeature((CompositeSlot)slot, call.getFeature());
        }
        return _xifexpression;
    }

    protected ExecutionSlot _resolveByFeature(CompositeSlot slot, EObject feature) {
        return slot;
    }

    protected ExecutionSlot _resolveByFeature(CompositeSlot slot, Property feature) {
        ExecutionSlot _xblockexpression = null;
        boolean _isExtensionProperty = this.ts.isExtensionProperty(feature);
        if (_isExtensionProperty) {
            return slot;
        }
        _xblockexpression = this.resolveByName(slot, (NamedElement)feature);
        return _xblockexpression;
    }

    protected ExecutionSlot _resolveByFeature(CompositeSlot slot, Operation feature) {
        return this.resolveByName(slot, (NamedElement)feature);
    }

    protected ExecutionSlot _resolveByFeature(CompositeSlot slot, Event feature) {
        return this.resolveByName(slot, (NamedElement)feature);
    }

    protected ExecutionSlot _resolveByName(ExecutionContext slot, NamedElement element) {
        ExecutionSlot _xblockexpression = null;
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, "default");
        };
        CompositeSlot defaultSlot = (CompositeSlot)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)slot.getSlots(), CompositeSlot.class), (Functions.Function1)_function);
        ExecutionSlot _elvis = null;
        Functions.Function1 _function_1 = it -> {
            String _name = it.getName();
            String _name_1 = element.getName();
            return Objects.equals(_name, _name_1);
        };
        ExecutionSlot _findFirst = (ExecutionSlot)IterableExtensions.findFirst((Iterable)slot.getSlots(), (Functions.Function1)_function_1);
        if (_findFirst != null) {
            _elvis = _findFirst;
        } else {
            ExecutionSlot _xifexpression = null;
            if (defaultSlot != null) {
                _xifexpression = this.resolveByName(defaultSlot, element);
            }
            _elvis = _xifexpression;
        }
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    protected ExecutionSlot _resolveByName(CompositeSlot slot, NamedElement element) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _name_1 = element.getName();
            return Objects.equals(_name, _name_1);
        };
        return (ExecutionSlot)IterableExtensions.findFirst((Iterable)slot.getSlots(), (Functions.Function1)_function);
    }

    protected ExecutionSlot packageNamespaceAwareResolve(ExecutionContext context, EObject element) {
        return context.getSlot(this._iQualifiedNameProvider.getFullyQualifiedName(element).toString());
    }

    protected String name(EObject e) {
        return (String)SimpleAttributeResolver.NAME_RESOLVER.apply(e);
    }

    protected ExecutionSlot _resolveArrayElement(ExecutionContext context, ExecutionSlot slot, List<Expression> arraySelectors, TypeSpecifier specifier) {
        ExecutionSlot _xblockexpression = null;
        ExecutionSlot arrayElementSlot = slot;
        Functions.Function1 _function = it -> {
            int _index = this.toIndex((Expression)it, context);
            return _index + 1;
        };
        List sizes = ListExtensions.map(arraySelectors, (Functions.Function1)_function);
        this.createDynamicArraySlots((CompositeSlot)arrayElementSlot, (TypeSpecifier)IterableExtensions.head((Iterable)specifier.getTypeArguments()), sizes);
        Functions.Function1 _function_1 = it -> this.toIndex((Expression)it, context);
        List _map = ListExtensions.map(arraySelectors, (Functions.Function1)_function_1);
        Iterator iterator = _map.iterator();
        while (iterator.hasNext()) {
            int arrayIndex = (Integer)iterator.next();
            arrayElementSlot = (ExecutionSlot)((CompositeSlot)arrayElementSlot).getSlots().get(arrayIndex);
        }
        _xblockexpression = arrayElementSlot;
        return _xblockexpression;
    }

    protected ExecutionSlot _resolveArrayElement(ExecutionContext context, ReferenceSlot slot, List<Expression> arraySelectors, TypeSpecifier specifier) {
        boolean _tripleNotEquals;
        ExecutionSlot _reference = slot.getReference();
        boolean bl = _tripleNotEquals = _reference != null;
        if (_tripleNotEquals) {
            return this.resolveArrayElement(context, slot.getReference(), arraySelectors, specifier);
        }
        return null;
    }

    protected void createDynamicArraySlots(CompositeSlot arrayElementSlot, TypeSpecifier elementTypeSpecifer, Iterable<Integer> sizes) {
        Integer _head;
        boolean _lessThan;
        int currentSize = arrayElementSlot.getSlots().size();
        boolean bl = _lessThan = currentSize < (_head = (Integer)IterableExtensions.head(sizes));
        if (_lessThan) {
            Integer _head_1 = (Integer)IterableExtensions.head(sizes);
            int _minus = _head_1 - 1;
            IntegerRange _upTo = new IntegerRange(currentSize, _minus);
            for (Integer i : _upTo) {
                boolean _not;
                ExecutionSlot _newInstance = this.slotInitializer.newInstance((EObject)elementTypeSpecifer);
                Procedures.Procedure1 _function = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("[");
                    _builder.append((Object)i);
                    _builder.append("]");
                    it.setName(_builder.toString());
                    it.setType(elementTypeSpecifer.getType());
                };
                ExecutionSlot newSlot = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_newInstance, (Procedures.Procedure1)_function);
                List _slots = arrayElementSlot.getSlots();
                _slots.add(newSlot);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.drop(sizes, (int)1));
                boolean bl2 = _not = !_isEmpty;
                if (!_not) continue;
                this.createDynamicArraySlots((CompositeSlot)newSlot, (TypeSpecifier)IterableExtensions.head((Iterable)elementTypeSpecifer.getTypeArguments()), IterableExtensions.drop(sizes, (int)1));
            }
        } else {
            boolean _not;
            List _slots = arrayElementSlot.getSlots();
            Integer _head_2 = (Integer)IterableExtensions.head(sizes);
            int _minus_1 = _head_2 - 1;
            ExecutionSlot slot = (ExecutionSlot)_slots.get(_minus_1);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.drop(sizes, (int)1));
            boolean bl3 = _not = !_isEmpty;
            if (_not) {
                this.createDynamicArraySlots((CompositeSlot)slot, (TypeSpecifier)IterableExtensions.head((Iterable)elementTypeSpecifer.getTypeArguments()), IterableExtensions.drop(sizes, (int)1));
            }
        }
    }

    protected int toIndex(Expression arraySelector, ExecutionContext context) {
        Object _evaluate = this._iExpressionInterpreter.evaluate(arraySelector, context);
        return ((Long)_evaluate).intValue();
    }

    @Override
    @XbaseGenerated
    public Optional<ExecutionSlot> resolve(ExecutionContext context, Expression e) {
        if (e instanceof ElementReferenceExpression) {
            return this._resolve(context, (ElementReferenceExpression)e);
        }
        if (e instanceof FeatureCall) {
            return this._resolve(context, (FeatureCall)e);
        }
        if (e instanceof AssignmentExpression) {
            return this._resolve(context, (AssignmentExpression)e);
        }
        if (e instanceof TypeCastExpression) {
            return this._resolve(context, (TypeCastExpression)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(context, e).toString());
    }

    @XbaseGenerated
    protected ExecutionSlot resolveByFeature(ExecutionContext context, FeatureCall e, EObject feature) {
        if (feature instanceof Event) {
            return this._resolveByFeature(context, e, (Event)feature);
        }
        if (feature instanceof Operation) {
            return this._resolveByFeature(context, e, (Operation)feature);
        }
        if (feature instanceof Property) {
            return this._resolveByFeature(context, e, (Property)feature);
        }
        if (feature != null) {
            return this._resolveByFeature(context, e, feature);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(context, e, feature).toString());
    }

    @XbaseGenerated
    protected ExecutionSlot resolveFromSlot(ExecutionSlot slot, EObject call) {
        if (slot instanceof ReferenceSlot && call instanceof Operation) {
            return this._resolveFromSlot((ReferenceSlot)slot, (Operation)call);
        }
        if (slot instanceof ReferenceSlot && call instanceof FeatureCall) {
            return this._resolveFromSlot((ReferenceSlot)slot, (FeatureCall)call);
        }
        if (slot instanceof CompositeSlot && call instanceof Operation) {
            return this._resolveFromSlot((CompositeSlot)slot, (Operation)call);
        }
        if (slot instanceof CompositeSlot && call instanceof FeatureCall) {
            return this._resolveFromSlot((CompositeSlot)slot, (FeatureCall)call);
        }
        if (slot != null && call instanceof FeatureCall) {
            return this._resolveFromSlot(slot, (FeatureCall)call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, call).toString());
    }

    @XbaseGenerated
    protected ExecutionSlot resolveByFeature(CompositeSlot slot, EObject feature) {
        if (feature instanceof Event) {
            return this._resolveByFeature(slot, (Event)feature);
        }
        if (feature instanceof Operation) {
            return this._resolveByFeature(slot, (Operation)feature);
        }
        if (feature instanceof Property) {
            return this._resolveByFeature(slot, (Property)feature);
        }
        if (feature != null) {
            return this._resolveByFeature(slot, feature);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, feature).toString());
    }

    @XbaseGenerated
    protected ExecutionSlot resolveByName(CompositeSlot slot, NamedElement element) {
        if (slot instanceof ExecutionContext) {
            return this._resolveByName((ExecutionContext)slot, element);
        }
        if (slot != null) {
            return this._resolveByName(slot, element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, element).toString());
    }

    @XbaseGenerated
    protected ExecutionSlot resolveArrayElement(ExecutionContext context, ExecutionSlot slot, List<Expression> arraySelectors, TypeSpecifier specifier) {
        if (slot instanceof ReferenceSlot) {
            return this._resolveArrayElement(context, (ReferenceSlot)slot, arraySelectors, specifier);
        }
        if (slot != null) {
            return this._resolveArrayElement(context, slot, arraySelectors, specifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(context, slot, arraySelectors, specifier).toString());
    }
}

