/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.types;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class PackageHelper {
    @Inject
    @Extension
    protected IPackageImport2URIMapper includeMapper;

    public List<Package> importedPackages(EObject it) {
        return this.provideImportedPackages(it);
    }

    protected List<Package> _provideImportedPackages(EObject it) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected List<Package> _provideImportedPackages(Package it) {
        ArrayList packages = CollectionLiterals.newArrayList();
        ResourceSet set = it.eResource().getResourceSet();
        Consumer<IPackageImport2URIMapper.PackageImport> _function = import_ -> {
            Resource resource = set.getResource(import_.getFileURI(), true);
            Package pkg = (Package)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), Package.class));
            if (pkg != null) {
                packages.add(pkg);
            }
        };
        this.packageImports(it).forEach(_function);
        return packages;
    }

    protected List<Package> importedPackages(Iterable<IPackageImport2URIMapper.PackageImport> pkgImports, ResourceSet set) {
        ArrayList packages = CollectionLiterals.newArrayList();
        Consumer<IPackageImport2URIMapper.PackageImport> _function = import_ -> {
            Resource resource = set.getResource(import_.getFileURI(), true);
            Package pkg = (Package)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), Package.class));
            if (pkg != null) {
                packages.add(pkg);
            }
        };
        pkgImports.forEach(_function);
        return packages;
    }

    protected Iterable<IPackageImport2URIMapper.PackageImport> packageImports(Package pkg) {
        Functions.Function1 _function = it -> this.includeMapper.findPackageImport(pkg.eResource(), it);
        Functions.Function1 _function_1 = it -> it.isPresent();
        Functions.Function1 _function_2 = it -> (IPackageImport2URIMapper.PackageImport)it.get();
        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)pkg.getImports(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }

    @XbaseGenerated
    protected List<Package> provideImportedPackages(EObject it) {
        if (it instanceof Package) {
            return this._provideImportedPackages((Package)it);
        }
        if (it != null) {
            return this._provideImportedPackages(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

