/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.create.base.generator.csharp.codepattern;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.itemis.create.base.generator.core.types.Literals;
import com.itemis.create.base.generator.csharp.codemodel.CsharpNamespace;
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.typesystem.ITypeSystem;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class CsharpLiterals
extends Literals {
    public static final String NULL_LITERAL_NAME = "null";
    public static final String TRUE_LITERAL_NAME = "true";
    public static final String FALSE_LITERAL_NAME = "false";
    private static String DOUBLE = "double";
    private static String BOOL = "bool";
    private static String LONG = "long";
    public static final String SEPARATOR_TOKEN = ".";
    @Inject
    @Extension
    protected ITypeSystem _iTypeSystem;
    @Inject
    @Extension
    protected CsharpNamespace _csharpNamespace;
    @Inject
    @Extension
    protected CsharpTypeBuilder _csharpTypeBuilder;

    public String NULL_LITERAL() {
        return NULL_LITERAL_NAME;
    }

    public String TRUE_LITERAL() {
        return TRUE_LITERAL_NAME;
    }

    public String FALSE_LITERAL() {
        return FALSE_LITERAL_NAME;
    }

    public String ENUM_SEPARATOR() {
        return SEPARATOR_TOKEN;
    }

    public String NAMESPACE_SEPARATOR() {
        return SEPARATOR_TOKEN;
    }

    protected String _asLiteral(Type type) {
        boolean _isString;
        boolean _isBoolean;
        boolean _isReal;
        String _switchResult = null;
        boolean _matched = false;
        if (type == null || this._iTypeSystem.isSame(type, this._iTypeSystem.getType("void"))) {
            _matched = true;
            _switchResult = "void";
        }
        if (!_matched && (_isReal = this._iTypeSystem.isReal(type))) {
            _matched = true;
            _switchResult = DOUBLE;
        }
        if (!_matched && (this._iTypeSystem.isInteger(type) || this._iTypeSystem.isSuperType(type, this._iTypeSystem.getType("integer")))) {
            _matched = true;
            _switchResult = LONG;
        }
        if (!_matched && (_isBoolean = this._iTypeSystem.isBoolean(type))) {
            _matched = true;
            _switchResult = BOOL;
        }
        if (!_matched && (_isString = this._iTypeSystem.isString(type))) {
            _matched = true;
            _switchResult = "string";
        }
        if (!_matched) {
            _switchResult = super._asLiteral(type);
        }
        return _switchResult;
    }

    protected String _asLiteral(Package it) {
        String _xifexpression = null;
        boolean _isCsNamespace = this._csharpNamespace.isCsNamespace(it);
        if (_isCsNamespace) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = it.getName();
            _builder.append(_name);
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = super._asLiteral(it);
        }
        return _xifexpression;
    }

    @XbaseGenerated
    public String asLiteral(Object it) {
        if (it instanceof Enumerator) {
            return this._asLiteral((Enumerator)it);
        }
        if (it instanceof Package) {
            return this._asLiteral((Package)it);
        }
        if (it instanceof Type) {
            return this._asLiteral((Type)it);
        }
        if (it instanceof Declaration) {
            return this._asLiteral((Declaration)it);
        }
        if (it instanceof List) {
            return this._asLiteral((List)it);
        }
        if (it instanceof TypeSpecifier) {
            return this._asLiteral((TypeSpecifier)it);
        }
        if (it instanceof Boolean) {
            return this._asLiteral((Boolean)it);
        }
        if (it instanceof Number) {
            return this._asLiteral((Number)it);
        }
        if (it instanceof String) {
            return this._asLiteral((String)it);
        }
        if (it == null) {
            return this._asLiteral(null);
        }
        return this._asLiteral(it);
    }
}

