/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.base.types.scoping.TypeSystemAwareScope;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.scoping.ImportedResourceCache;
import com.yakindu.sct.model.stext.stext.ImportScope;
import com.yakindu.sct.model.stext.stext.StextPackage;
import com.yakindu.sctunit.DomainInjectorProvider;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.DefaultGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.LoadOnDemandResourceDescriptions;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.IResourceScopeCache;

public class SCTUnitGlobalScopeProvider
extends DefaultGlobalScopeProvider {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private DomainInjectorProvider domainInjectorProvider;
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private Provider<LoadOnDemandResourceDescriptions> loadOnDemandDescriptions;
    @Inject
    private ImportedResourceCache resourceDescriptionCache;
    @Inject
    private STextExtensions utils;

    public IScope getScope(Resource context, EReference reference, Predicate<IEObjectDescription> filter) {
        if (reference == SCTUnitPackage.Literals.SCT_UNIT_CLASS__STATECHART) {
            return super.getScope(context, reference, filter);
        }
        Statechart statechart = this.getStatechart(context);
        if (statechart == null) {
            return super.getScope(context, reference, filter);
        }
        IScope result = super.getScope(context, reference, (Predicate)new SameStatechartPredicate(statechart));
        if (statechart != null && statechart.eResource() != null) {
            result = this.addStatechartImportScope(result, statechart, (EClass)reference.getEType(), filter);
        }
        result = this.addTypeSystemScope(result, statechart, reference);
        return new FilteringScope(result, input -> {
            String isVisible = input.getUserData("is_visible_type");
            return isVisible == null || Boolean.valueOf(isVisible) != false;
        });
    }

    protected IScope addStatechartImportScope(IScope parent, Statechart statechart, EClass type, Predicate<IEObjectDescription> filter) {
        LinkedHashSet<URI> uniqueImportURIs = this.getImportedUris(statechart);
        IResourceDescriptions descriptions = this.getResourceDescriptions(statechart, uniqueImportURIs);
        ArrayList urisAsList = Lists.newArrayList(uniqueImportURIs);
        Collections.reverse(urisAsList);
        ArrayList objectDescriptions = new ArrayList();
        for (URI uri : urisAsList) {
            parent = this.createLazyResourceScope(parent, uri, descriptions, type, filter, false);
        }
        return MapBasedScope.createScope((IScope)parent, objectDescriptions);
    }

    protected LinkedHashSet<URI> getImportedUris(final Statechart statechart) {
        return (LinkedHashSet)this.cache.get(SCTUnitGlobalScopeProvider.class, statechart.eResource(), (Provider)new Provider<LinkedHashSet<URI>>(){

            public LinkedHashSet<URI> get() {
                LinkedHashSet<URI> result = new LinkedHashSet<URI>();
                List importsOfStatechart = EcoreUtil2.getAllContentsOfType((EObject)statechart, ImportScope.class);
                IPackageImport2URIMapper import2UriMapper = (IPackageImport2URIMapper)SCTUnitGlobalScopeProvider.this.domainInjectorProvider.getInjector(statechart).getInstance(IPackageImport2URIMapper.class);
                for (ImportScope importScope : importsOfStatechart) {
                    for (String importString : importScope.getImports()) {
                        Optional packageImport = import2UriMapper.findPackageImport(statechart.eResource(), importString);
                        if (!packageImport.isPresent()) continue;
                        URI uri = ((IPackageImport2URIMapper.PackageImport)packageImport.get()).getUri();
                        result.add(uri);
                    }
                }
                return result;
            }
        });
    }

    public IResourceDescriptions getResourceDescriptions(Statechart statechart, Collection<URI> importUris) {
        IResourceDescriptions result = this.getResourceDescriptions(statechart.eResource());
        LoadOnDemandResourceDescriptions demandResourceDescriptions = (LoadOnDemandResourceDescriptions)this.loadOnDemandDescriptions.get();
        demandResourceDescriptions.initialize(result, importUris, statechart.eResource());
        return demandResourceDescriptions;
    }

    protected IScope createLazyResourceScope(IScope parent, URI uri, IResourceDescriptions descriptions, EClass type, Predicate<IEObjectDescription> filter, boolean ignoreCase) {
        IResourceDescription description = this.resourceDescriptionCache.get(uri);
        if (description == null) {
            return IScope.NULLSCOPE;
        }
        return SelectableBasedScope.createScope((IScope)parent, (ISelectable)description, filter, (EClass)type, (boolean)ignoreCase);
    }

    protected IScope addTypeSystemScope(IScope parentScope, Statechart statechart, EReference reference) {
        if (statechart == null) {
            return parentScope;
        }
        Injector resourceInjector = this.domainInjectorProvider.getInjector(statechart);
        ITypeSystem typesystem = (ITypeSystem)resourceInjector.getInstance(ITypeSystem.class);
        return new TypeSystemAwareScope(parentScope, typesystem, this.qualifiedNameProvider, reference.getEReferenceType());
    }

    protected Statechart getStatechart(Resource context) {
        TreeIterator allContents = context.getAllContents();
        while (allContents.hasNext()) {
            EObject current = (EObject)allContents.next();
            if (current instanceof Statechart) {
                return (Statechart)current;
            }
            if (!(current instanceof SCTUnitClass)) continue;
            return ((SCTUnitClass)current).getStatechart();
        }
        return this.utils.getStatechart(context);
    }

    protected static class SameStatechartPredicate
    implements Predicate<IEObjectDescription> {
        private URI statechartUri;

        public SameStatechartPredicate(Statechart statechart) {
            this.statechartUri = EcoreUtil.getURI((EObject)statechart).trimFragment();
        }

        public boolean apply(IEObjectDescription input) {
            if (input.getEClass().getEPackage() == SGraphPackage.eINSTANCE || input.getEClass().getEPackage() == TypesPackage.eINSTANCE || input.getEClass().getEPackage() == StextPackage.eINSTANCE) {
                URI descriptionURI = input.getEObjectURI().trimFragment();
                return descriptionURI.equals(this.statechartUri);
            }
            return true;
        }
    }
}

