/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.xformation.lmx.LmxLicenseInfo;
import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.ILicenseEventListener;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.GeneralExceptionHelper;
import com.yakindu.licmgmt.internal.ILicenseSettings;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.LicenseSettings;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.internal.events.LicenseEvent;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class LicenseService
implements ILicenseService {
    public static final boolean DEBUG = LicenseService.isDebugWireProtocol();
    private final Map<String, LicenseManager> registry = new HashMap<String, LicenseManager>();
    private final Collection<ILicenseEventListener> licenseEventListeners = new CopyOnWriteArrayList<ILicenseEventListener>();
    private final LicenseSettings licenseSettings;

    private static boolean isDebugWireProtocol() {
        try {
            String runtimeArgs = ManagementFactory.getRuntimeMXBean().getInputArguments().toString();
            return runtimeArgs.contains("-agentlib:jdwp") || runtimeArgs.contains("-Xrunjdwp");
        }
        catch (Throwable t) {
            return false;
        }
    }

    public LicenseService() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Please use ILicenseService.INSTANCE to access the license service.");
        }
        LoggingHelper.info("Initializing itemis license management service; OS: " + System.getProperty("os.name"), new Object[0]);
        this.addEventListener(new EventListener());
        this.licenseSettings = new LicenseSettings();
        Runtime.getRuntime().addShutdownHook(new shutdownHook());
    }

    public ILicenseSettings getSettings() {
        return this.licenseSettings;
    }

    @Override
    public ServerSettings getServerSettings() {
        return this.licenseSettings.getServerSettings();
    }

    @Override
    public void setServerSettings(ServerSettings newServerSettings) {
        this.licenseSettings.setServerSettings(newServerSettings);
    }

    @Override
    public ILicenseManager getLicenseManager(String featureId, String featureVersion) throws LicenseException {
        return this.getLicenseManager(featureId, featureVersion, Collections.emptyList());
    }

    @Override
    public ILicenseManager getLicenseManager(String featureId, String featureVersion, String additionalPath) throws LicenseException {
        return this.getLicenseManager(featureId, featureVersion, Collections.singletonList(additionalPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILicenseManager getLicenseManager(String featureId, String featureVersion, List<String> additionalPaths) throws LicenseException {
        boolean newLicenseManagerCreated = false;
        LicenseManager manager = this.registry.get(featureId);
        if (manager == null) {
            Map<String, LicenseManager> map = this.registry;
            synchronized (map) {
                manager = this.registry.get(featureId);
                if (manager == null) {
                    manager = new LicenseManager(featureId, featureVersion, additionalPaths);
                    this.registry.put(featureId, manager);
                    newLicenseManagerCreated = true;
                }
            }
        }
        if (!newLicenseManagerCreated) {
            if (!manager.getFeatureVersion().equals(featureVersion)) {
                GeneralExceptionHelper.throwBasicLicenseException(String.format("License manager for feature '%s' already initialized for different version (%s vs %s)", featureId, featureVersion, manager.getFeatureVersion()));
            }
            manager.checkForUpdatedLicensePaths(additionalPaths);
        }
        LoggingHelper.info(String.valueOf(newLicenseManagerCreated ? "Created" : "Using existing") + " license manager for feature '%s' with version '%s'.", featureId, featureVersion);
        return manager;
    }

    @Override
    public Collection<ILicenseManager> getAllLicenseManagers() {
        return Collections.unmodifiableCollection(this.registry.values());
    }

    public void clear() {
        this.registry.clear();
        this.licenseSettings.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndRemoveLicenseManager(ILicenseManager licenseManager) {
        LoggingHelper.debug("Shutting down and removing LicenseManager for feature '%s'.", licenseManager.getFeatureId());
        ILicenseManager iLicenseManager = licenseManager;
        synchronized (iLicenseManager) {
            LmxStatus status = licenseManager.release();
            if (LmxStatus.LMX_SUCCESS.equals((Object)status)) {
                ((LicenseManager)licenseManager).shutdown();
                this.registry.remove(licenseManager.getFeatureId());
                licenseManager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAllLicenseManagers() {
        LoggingHelper.debug("Shutting down and removing all LicenseManagers...", new Object[0]);
        Class<LicenseService> clazz = LicenseService.class;
        synchronized (LicenseService.class) {
            ILicenseManager[] managers = this.getAllLicenseManagers().toArray(new ILicenseManager[0]);
            int i = 0;
            while (i < managers.length) {
                this.shutdownAndRemoveLicenseManager(managers[i]);
                ++i;
            }
            this.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static List<LmxLicenseInfo> getAllAvailableFeatures(String[] paths) {
        throw new UnsupportedOperationException("This feature is not supported any more by LM-X and will be removed in the next version.");
    }

    public void postEvent(LicenseEvent event) {
        for (ILicenseEventListener eventListener : this.licenseEventListeners) {
            try {
                eventListener.event(event);
            }
            catch (Exception exception) {
                LoggingHelper.error("Event listener '%s' threw an unexpected %s while processing event: %s", exception, eventListener.getClass().getCanonicalName(), exception.getClass().getSimpleName(), event);
            }
        }
    }

    public boolean addEventListener(ILicenseEventListener listener) {
        return this.licenseEventListeners.add(listener);
    }

    public boolean removeEventListener(ILicenseEventListener listener) {
        return this.licenseEventListeners.remove(listener);
    }

    private class EventListener
    implements ILicenseEventListener {
        private EventListener() {
        }

        @Override
        public void event(ILicenseEventListener.ILicenseEvent event) {
            LoggingHelper.info("Event occurred: %s", event);
            if (DEBUG) {
                System.err.println("License Event: " + event);
            }
        }
    }

    static class shutdownHook
    extends Thread {
        shutdownHook() {
        }

        @Override
        public void run() {
            LoggingHelper.debug("Shutdown hook called.", new Object[0]);
            ((LicenseService)INSTANCE).shutdownAllLicenseManagers();
            super.run();
        }
    }
}

