/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.events;

import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.events.LicenseEvent;

public class LicenseErrorEvent
extends LicenseEvent {
    private LicenseErrorEvent(String reason, String featureId) {
        super(reason, featureId);
    }

    public static LicenseEvent createForFailedCheckout(LicenseManager licenseManager) {
        String reason = "Checkout failed: " + licenseManager.getSimpleErrorMessage();
        return new LicenseErrorEvent(reason, licenseManager.getFeatureId());
    }

    public static LicenseEvent createForLastFailedHeartbeat(LicenseManager licenseManager) {
        return new LicenseErrorEvent("License Server connection lost: " + licenseManager.getSimpleErrorMessage(), licenseManager.getFeatureId());
    }

    public static LicenseEvent createForFailedDongle(LicenseManager licenseManager) {
        return new LicenseErrorEvent("Dongle failure: " + licenseManager.getStatusMessage(), licenseManager.getFeatureId());
    }

    public static LicenseEvent createForExpiredFeature(LicenseManager licenseManager) {
        return new LicenseErrorEvent("License expired: " + licenseManager.getStatusMessage(), licenseManager.getFeatureId());
    }

    public static LicenseEvent createForSettingsUpdate(String msg, String featureId) {
        return new LicenseErrorEvent(msg, featureId);
    }
}

