/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.naming;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.generator.python.naming.Keywords;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sexec.Step;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.naming.DefaultNamingService;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class PythonNamingService
extends DefaultNamingService {
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private Naming _naming;
    private Set<String> derivedIdentifiers = new HashSet<String>();

    protected String prefix(Step it, char separator) {
        boolean _isReactSequence;
        boolean _isExitSequence;
        boolean _isShallowEnterSequence;
        boolean _isDeepEnterSequence;
        boolean _isEnterSequence;
        boolean _isEffect;
        boolean _isExitAction;
        boolean _isEntryAction;
        String _switchResult = null;
        boolean _matched = false;
        boolean _isCheckFunction = this._sExecExtensions.isCheckFunction(it);
        if (_isCheckFunction) {
            _matched = true;
            _switchResult = "check";
        }
        if (!_matched && (_isEntryAction = this._sExecExtensions.isEntryAction(it))) {
            _matched = true;
            _switchResult = "entry_action";
        }
        if (!_matched && (_isExitAction = this._sExecExtensions.isExitAction(it))) {
            _matched = true;
            _switchResult = "exit_action";
        }
        if (!_matched && (_isEffect = this._sExecExtensions.isEffect(it))) {
            _matched = true;
            _switchResult = "effect";
        }
        if (!_matched && (_isEnterSequence = this._sExecExtensions.isEnterSequence(it))) {
            _matched = true;
            _switchResult = "enter_sequence";
        }
        if (!_matched && (_isDeepEnterSequence = this._sExecExtensions.isDeepEnterSequence(it))) {
            _matched = true;
            _switchResult = "deep_enter_sequence";
        }
        if (!_matched && (_isShallowEnterSequence = this._sExecExtensions.isShallowEnterSequence(it))) {
            _matched = true;
            _switchResult = "shallow_enter_sequence";
        }
        if (!_matched && (_isExitSequence = this._sExecExtensions.isExitSequence(it))) {
            _matched = true;
            _switchResult = "exit_sequence";
        }
        if (!_matched && (_isReactSequence = this._sExecExtensions.isReactSequence(it))) {
            _matched = true;
            _switchResult = "react";
        }
        if (!_matched) {
            _switchResult = "";
        }
        return _switchResult;
    }

    public String asIdentifier(String string) {
        boolean _equals = Objects.equals(string, "");
        if (_equals) {
            return "";
        }
        Functions.Function1 _function = it -> StringExtensions.toFirstUpper((String)it.toString());
        return IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)string.split("\\."))), (CharSequence)"", (Functions.Function1)_function).replaceAll("(\\p{Lower})(\\p{Upper})", "$1_$2").replaceAll("\\^", "\\_").toLowerCase();
    }

    public String asEscapedIdentifier(String it) {
        Object s = it;
        boolean _isKeyword = this.isKeyword((String)s);
        if (_isKeyword) {
            s = (String)s + String.valueOf(Character.valueOf(this.separator)) + "ID";
        }
        return this.asIdentifier((String)s);
    }

    public boolean isKeyword(String name) {
        return this.isKeyword(Keywords.PYTHON_KEYWORD_SET, name);
    }

    public boolean isStatemachineIdentifier(String name) {
        return this.isKeyword(Keywords.STATEMACHICHNE_KEYWORD_SET, name);
    }

    public boolean isStatemachineInterfaceIdentifier(String name) {
        return this.isKeyword(Keywords.STATEMACHINE_INTERFACE_KEYWORD_SET, name);
    }

    public boolean isDerivedIdentifier(String name) {
        return this.isKeyword(this.getDerivedIdentifiers(), name);
    }

    public boolean isStatemachineMethod(String name) {
        return this.isKeyword(Keywords.STATEMACHINE_METHOD_SET, name);
    }

    private boolean isKeyword(Set<String> set, String name) {
        Functions.Function1 _function = it -> it.equalsIgnoreCase(name);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((String)IterableExtensions.findFirst(set, (Functions.Function1)_function)));
        return !_isNullOrEmpty;
    }

    public boolean isKeyword(NamedElement it) {
        boolean _isKeyword = this.isKeyword(it.getName());
        if (_isKeyword) {
            return true;
        }
        EObject _eContainer = it.eContainer();
        boolean _matched = false;
        if (_eContainer instanceof InterfaceScope) {
            _matched = true;
            return this.isStatemachineInterfaceIdentifier(it.getName());
        }
        if (!_matched && _eContainer instanceof InternalScope) {
            _matched = true;
            return this.isStatemachineIdentifier(it.getName()) || this.isDerivedIdentifier(it.getName()) || this.isStatemachineMethod(it.getName());
        }
        return false;
    }

    protected Set<String> getDerivedIdentifiers() {
        boolean _isEmpty = this.derivedIdentifiers.isEmpty();
        if (_isEmpty && this.activeFlow != null) {
            Consumer<InterfaceScope> _function = it -> this.derivedIdentifiers.add(this.asEscapedIdentifier(this._naming.interfaceTypeName((Scope)it).toString()));
            this._sExecExtensions.getNamedInterfaceScopes(this.activeFlow).forEach(_function);
        }
        return this.derivedIdentifiers;
    }
}

