/**
 * Copyright (c) 2020-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.exec

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.interpreter.base.InterpreterException
import com.yakindu.sct.model.sruntime.CompositeSlot
import com.yakindu.sct.model.sruntime.ExecutionSlot
import com.yakindu.sct.model.sruntime.ExecutionVariable
import com.yakindu.sct.model.sruntime.ReferenceSlot
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecExecution
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecInterpreter

/**
 * Interpreter specialization which handles for specific C domain concepts.
 * 
 * @author axel terfloth
 */
@Singleton
class CDomainSexecInterpreter extends SexecInterpreter {
	
	@Inject new(SexecExecution exec) {
		super(exec)
	}

	def dispatch Object resolveSlot(ExecutionVariable slot, String symbol) {
		if (symbol.isPointer ) return slot.pointer
		return null
	}

	override dispatch Object resolveSlot(ReferenceSlot slot, String symbol) {
		if (symbol.isPointerValue) return slot.reference
		if (symbol.isPointer ) return slot.pointer

		return super._resolveSlot(slot , symbol)
	}

	override dispatch Object resolveSlot(CompositeSlot slot, String symbol) {
		if (symbol.isPointer ) return slot.pointer
		
		return super._resolveSlot(slot , symbol)
	}


	def dispatch Object resolveSlot(ReferenceSlot slot, Long index) {

		if (slot.reference !== null)  
			return slot.reference.resolveSlot(index);

		throw new InterpreterException("Array access on null pointer.")
	}

	protected def isPointer(String symbol) {
		return "pointer" == symbol	
	}	
	
	protected def pointer(ExecutionSlot slot) {
		return createReferenceSlot => [
			reference = slot
		]
	}	
	
	protected def isPointerValue(String symbol) {
		return "value" == symbol	
	}	
}