/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.exec

import com.google.inject.Inject
import com.yakindu.base.expressions.interpreter.base.ValueSemantics
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sruntime.Any
import com.yakindu.sct.model.sruntime.CompositeSlot
import com.yakindu.sct.model.sruntime.ReferenceSlot
import com.yakindu.sct.model.sruntime.SRuntimeFactory

/**
 * Defines C domain specific extensions of the interpreter value semantics.
 * 
 * @author axel terfloth - Initial contribution and API  * 
 */
class CDomainValueSemantics extends ValueSemantics {

	@Inject protected ITypeSystem ts
	protected extension SRuntimeFactory srf = SRuntimeFactory.eINSTANCE

	/**
	 * If a composite slot is an array then an expression denoting this slot is a
	 * pointer in C and thus the value must be a reference slot.
	 */
	override dispatch Object asValue(CompositeSlot slot) {
		if (ts.isArray(slot.type)) {
			return createReferenceSlot => [
				name = slot.name
				reference = slot
			]			
		} else {
			super._asValue(slot)
		}
	}
	

	def dispatch void setValue(ReferenceSlot it, Any value) {
		it.reference = null
	}
	
}