/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.concepts

import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.stext.stext.EntryPointSpec
import java.util.List

class EntryTransition{

	def getEntrySpecSortedTransitions(List<Transition> it) {
		#[filter[properties.filter(EntryPointSpec).empty].toList,
			filter[!properties.filter(EntryPointSpec).empty].toList]
	}

	/**
	 * Returns the name of the specified entry point or 'default' if it does not exist
	 */
	def String entryPointName(Transition t) {
		val eps = t.properties.filter(typeof(EntryPointSpec)).head
		if(eps === null) 'default' else eps.entrypoint
	}

}
