/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.naming

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.concepts.EnterMethod
import com.yakindu.sct.model.sexec.concepts.ExitMethod
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.naming.StextNameProvider
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import org.eclipse.emf.ecore.EObject

class Naming {

	@Inject extension PythonNamingService namingService;
	@Inject extension StatechartUtil
	@Inject extension OriginTracing
	@Inject extension ShadowMemberScope
	@Inject extension SExecExtensions

	@Inject StextNameProvider provider;
	
	def Timer(){
		"timer_service"
	}

	def runtimeServiceClass() {
		"runtime_service"
	}

	def py(String it) {
		it + ".py"
	}
	
	def stateVector() {
		"__state_vector"
	}
	
	def stateIndex() {
		"__state_index"
	}
	
	def timerService() {
		"timer_service"
	}
	
	def timeEvents() {
		"__time_events"
	}
	
	def historyVector() {
		"__history_vector"
	}
	
	def historyIndex() {
		"__history_index"
	}
	
	def isStateActive() {
		"is_state_active"
	}
	
	def isActive() {
		"is_active"
	}
	
	def isFinal() {
		"is_final"
	}
	
	def stateInstance() {
		"__State"
	}

	def dispatch String statemachineName(String name) {
		// remove whitespaces;
		var String newName = name.replace(" ", "")
		if (name.isKeyword) {
			return newName + "sm_"
		}
		return newName
	}

	def dispatch String statemachineName(ExecutionFlow it) {
		return name.statemachineName.toFirstUpper()
	}
	
	def dispatch String statemachineName(Statechart it) {
		return name.statemachineName.toFirstUpper
	}

	def dispatch statemachineClassName(ExecutionFlow it) {
		statemachineName.asIdentifier
	}
	
	def dispatch statemachineClassName(Statechart it) {
		statemachineName.asIdentifier
	}

	def dispatch identifier(Property it) {
		if (it.const) {
			escaped.asIdentifier.toUpperCase
		} else if (scope.isInternalScope || eContainer instanceof ExecutionFlow) {
			"__" + escaped.asEscapedIdentifier
		} else {
			escaped.asIdentifier
		}
	}
	
	def dispatch identifier(Parameter it) {
		escaped.asIdentifier
	}
	
	def dispatch identifier(Declaration it) {
		escaped.asIdentifier
	}

	def dispatch String identifier(Event it) {
		'''«escaped.asIdentifier»'''
	}
	
	def dispatch identifier (EObject it) {
		"Cannot reference identifier of " + it
	}

	def dispatch String getValueIdentifier(Event it) {
		name.asIdentifier + "_value"
	}
	
	def dispatch String getValueIdentifier(EObject it) {
		"Cannot reference value identifier of " + it
	}
		
	def dispatch interfaceTypeName(InterfaceScope it) {
		name.toFirstUpper
	}
	
	def dispatch interfaceTypeName(Scope it) {
		'''no interface scope for «it.class.name»'''
	}
	
	def interfaceVariableName(InterfaceScope it) {
		interfaceTypeName.toString.asEscapedIdentifier
	}
		
	def dispatch operationCallbackInstance(InternalScope it) {
		"internal_operation_callback"
	}
	
	def dispatch operationCallbackInstance(InterfaceScope it) {
		"operation_callback"
	}
	
	def dispatch operationCallbackInstance(Scope it) {
		throw new IllegalArgumentException("No implementation found for operationCallbackInstance(Scope).")
	}

	def private String fullQualifiedStateName(String name) {
		name.substring(name.indexOf(".") + 1)
	}

	def dispatch String stateName(RegularState state) {
		val String name = provider.getFullyQualifiedName(state).toString();
		name.fullQualifiedStateName.asEscapedIdentifier
	}

	def dispatch String stateName(ExecutionState it) {
		val stateName = name.fullQualifiedStateName.asEscapedIdentifier
		if (stateName.startsWith("_")) {
			return stateName.substring(1)
		}
		return stateName
	}
	
	def dispatch String stateName(Enumerator it) {
		return originState?.stateName?:getNullStateName
	}

	def dispatch enumAccess(EnumerationType it) {
		return getOriginStatechart.statemachineName
	}
	
	def dispatch enumAccess(Declaration it) {
		""
	}
	
	def dispatch asObservable(Event it) {
		'''«name.asIdentifier»_observable'''
	}
	
	def asObserver(Event it) {
		'''«name.asIdentifier»_observer'''
	}
	
	def asObserverClass(Event it) {
		'''«name.asClassName»Observer'''
	}
	
	def dispatch asObservable(EObject it) {
		''''''
	}
	
	def asEscapedName(String it) {
		asEscapedIdentifier
	}
	
	def asClassName(String it) {
		it.split("_").join("","","", [toFirstUpper])
	}
	
	def dispatch private escaped(NamedElement it) {
		var varName = name
		if (isKeyword) {
			varName += "_variable"
		}
		return varName
	}
	
	def dispatch private escaped(Event it) {
		var varName = name
		if (isKeyword) {
			varName += "_event"
		}
		return varName
	}
	
	def String assign(Property it) {
		methodName("assign_", "")
	}
	
	def private methodName(Property it, String prefix, String suffix) {
		var methodName = prefix + name.asEscapedIdentifier

		if (isStatemachineMethod(methodName) || isDerivedIdentifier(name)) {
			methodName = prefix + escaped.asIdentifier
		}

		return methodName + suffix
	}
	
	def stateEnumName() {
		"State"
	}

	def String getNullStateName() {
		"null_state";
	}

	def functionName(Step it) { 
		shortName.toLowerCase
	}

	def functionName(Method it) { 
		shortName.toLowerCase
	}
	
	def rxpyModule() {
		"rx"
	}
	
	def eventBufferTypeName(Type it) {
		val typeOrigin = it.originTraces.filter(EObject).head
		typeOrigin.eventBufferPrefix + "EvBuf"
	}
	
	protected def dispatch eventBufferPrefix(EObject it) {
		"TimeEvents"
	}

	protected def dispatch eventBufferPrefix(InterfaceScope it) {
		interfaceTypeName ?: ""
	}

	protected def dispatch eventBufferPrefix(InternalScope it) {
		if (isShadowMemberScope) "Shadow" else "Internal"
	}

	protected def dispatch eventBufferPrefix(ExecutionFlow it) {
		statemachineName
	}
	
	def methodShortName(Method it) {
		if(!isAPI) return '''__«shortName»'''
		return shortName
	}
	
	def isAPI(Method it){
		switch name {
			case EnterMethod.ENTER: return true
			case RunCycleMethod.RUN_CYCLE: return true
			case ExitMethod.EXIT: return true
		}
		return false
	}
	
	def isRaisedFunctionName(Event it) {
		'''is_raised_«escaped.asIdentifier»'''
	}
	
	def raiseFunctionName(Event it) {
		'''raise_«escaped.asIdentifier»'''
	}
	
	def raiseCallFunctionName(Event it) {
		'''__raise_«escaped.asIdentifier»_call'''
	}
	
}
