/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.python.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.python.FlowCode
import com.yakindu.sct.generator.python.PythonExpressionsGenerator
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.base.types.Operation

/**
 * @author Robin Herrmann
 */
class InternalFunctionsGenerator {
	
	@Inject extension SExecExtensions
	@Inject extension Naming
	@Inject extension INamingService
	@Inject extension FlowCode
	@Inject protected extension TriggerWithoutEventMethod
	@Inject protected extension PythonExpressionsGenerator
	
	def functionImplementations(ExecutionFlow it) '''
		«checkFunctions.toImplementation»
		«effectFunctions.toImplementation»
		«entryActionFunctions.toImplementation»
		«exitActionFunctions.toImplementation»
		«enterSequenceFunctions.toImplementation»
		«exitSequenceFunctions.toImplementation»
		«reactFunctions.filter[ f | ! (f.eContainer instanceof ExecutionState)].toImplementation»
		«reactMethods.toDefinitions»
		«methods.toDefinitions»
		«IF hasTriggerWithoutEvents»
		«implementation(triggerWithoutEvents)»
		«ENDIF»
	'''
	
	def toDefinitions(Iterable<Method> methods) '''
		«FOR m : methods»
			«implementation(m)»
			
		«ENDFOR»
	'''
	 
	 def dispatch implementation(Operation it) '''
		def «name.asEscapedIdentifier»(self«FOR p : parameters  BEFORE ', ' SEPARATOR ', '»«IF p.varArgs»*args«ELSE»«p.name.asIdentifier»«ENDIF»«ENDFOR»):
			"""Implementation of «name» function.
			"""
			«implementation.code»
		
	'''
	 
	 def dispatch implementation(Method it) '''
		def «methodShortName»(self«FOR p : parameters  BEFORE ', ' SEPARATOR ', '»«IF p.varArgs»*args«ELSE»«p.name.asIdentifier»«ENDIF»«ENDFOR»):
			"""Implementation of «methodShortName» function.
			"""
			«body.code»
		
	'''

	def toImplementation(Iterable<Step> steps) '''
		«FOR s : steps»
			«s.functionImplementation»
		«ENDFOR»
	'''
	
	def dispatch functionImplementation(Check it) '''
		def __«functionName»(self):
			"""«comment».
			"""
			return «code.toString.trim»
			
	'''
	
	def dispatch functionImplementation(Step it) '''
		def __«functionName»(self):
			"""«comment».
			"""
			«IF code.toString.empty»
				pass
			«ELSE»
				«code.toString.trim»
			«ENDIF»
			
	'''
}