/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.ExpressionsChecker
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CodeGeneratorFragmentProvider
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author axel terfloth
 */
class StatemachineImplementation implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected CodeGeneratorFragmentProvider provider;
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension ExpressionsChecker
	
	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		val namespace = statechartNamespace
	'''	
		«entry.licenseText»
		
		#include "«(module.h).relativeTo(module.cpp)»"
		«IF hasStringComparison»#include <string.h>«ENDIF»
		«IF modOnReal»#include <math.h>«ENDIF»
		
		/*! \file
		Implementation of the state machine '«name»'
		*/
		
		«IF !namespace.nullOrEmpty»
		«FOR ns : namespace»
		namespace «ns» {
		«ENDFOR»
		«ENDIF»
		
		«provider.get(this.class.simpleName, it, artifactConfigs)»
		
		«IF !namespace.nullOrEmpty»
		«FOR ns : namespace»
		}
		«ENDFOR»
		«ENDIF»
	'''
	}
}