/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

/**
 * @author axel terfloth
 */
class TimingFunctions {
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension SExecExtensions
	@Inject protected extension CppPointers
	@Inject protected extension CppTypes
	@Inject protected extension CppSpecifiers
	
	def timedStatemachineFunctions(ExecutionFlow it) '''
		«IF timed»
			
			void «module»::«SET_TIMER_SERVICE»(«sharedPtr»«scTimerNS»::«timerInterface»«pointerType» «timerArgument»)«_noexcept»
			{
				this->«timerInstance» = «timerArgument»;
			}
			
			«sharedPtr»«scTimerNS»::«timerInterface»«pointerType» «module»::«GET_TIMER_SERVICE»()«_noexcept»
			{
				return «timerInstance»;
			}
			
			«sc_integer.fqName» «module»::«numTimeEventsFctID»()«_noexcept» {
				return «timeEventsCountparallelConst»;
			}
			
			«raiseTimeEventFunction»
			
		«ENDIF»
	'''
	
	def raiseTimeEventFunction(ExecutionFlow it) '''
		void «module»::«raiseTimeEventFctID»(«sc_eventid.fqName» evid)
		{
			if ((evid >= («sc_eventid.fqName»)«timeEventsInstance») && (evid < («sc_eventid.fqName»)(&«timeEventsInstance»[«timeEventsCountConst»])))
			{
				*(«sc_bool.fqName»*)evid = true;
			}
		}
	'''
	
	def timedStatemachineFunctionPrototypes(ExecutionFlow it) '''
		/*
		 * Functions inherited from TimedStatemachineInterface
		 */
		virtual void «SET_TIMER_SERVICE»(«scTimerNS»::«timerInterface»* «timerArgument»);
		
		virtual «scTimerNS»::«timerInterface»* «GET_TIMER_SERVICE»();
		
		virtual void «raiseTimeEventFctID»(«sc_eventid.fqName» event);
		
		virtual «sc_integer.fqName» «numTimeEventsFctID»();
		
	'''
		
}