/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.types

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.annotations.NamespaceAnnotations
import com.google.inject.Singleton

/**
 * Implements C++98 specific literals.
 * 
 * @author axel terfloth - Initial contribution.
 */
@Singleton
class CppLiterals extends Literals {
	
	@Inject protected extension CppTypes
	@Inject protected extension NamespaceAnnotations
	
	public static final String TRUE_LITERAL_NAME = "true";
	public static final String FALSE_LITERAL_NAME = "false";
	public static final String SEPARATOR_TOKEN = "::";
	public static final String NULL_LITERAL_NAME = "sc_null";
	
	override TRUE_LITERAL() {
		return TRUE_LITERAL_NAME
	}
	
	override FALSE_LITERAL() {
		return FALSE_LITERAL_NAME
	}
	
	override dispatch String asLiteral(String v) {
		'''(«sc_string.fqName»)"«v»"'''	
	}
	
	override dispatch String asLiteral(Enumerator e) {
		'''«e.name»'''
	}
	
	override NULL_LITERAL(){ NULL_LITERAL_NAME }
	
	override ENUM_SEPARATOR() { SEPARATOR_TOKEN }
	
	override NAMESPACE_SEPARATOR() { SEPARATOR_TOKEN }
	
}