/**
 * Copyright (c) 2020-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.ui.contentassist

import com.yakindu.base.types.annotations.DeprecatedAnnotations
import com.google.inject.Inject
import org.eclipse.emf.ecore.EObject
import org.eclipse.jface.viewers.StyledString
import org.eclipse.jface.viewers.StyledString.Styler
import org.eclipse.swt.SWT
import org.eclipse.swt.graphics.TextStyle
import org.eclipse.swt.widgets.Display
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.CrossReference
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class ExpressionsProposalProvider extends AbstractExpressionsProposalProvider {
	
	@Inject protected extension DeprecatedAnnotations
	
	protected static final Styler DEPRECATED_STYLE = new Styler() {
				override applyStyles(TextStyle textStyle) {
					textStyle.foreground = Display.current.getSystemColor(SWT.COLOR_DARK_GRAY)
					textStyle.strikeout = true
					textStyle.strikeoutColor = textStyle.foreground 
				}
			};
			
			
	override void completeFeatureCall_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		lookupCrossReference((assignment.getTerminal() as CrossReference), context, acceptor);
		
	}

	override protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
		val displayString = new StyledString(getDisplayString(element, qualifiedName, shortName));
		if (element.isDeprecated) {
			displayString.setStyle(0,displayString.length, DEPRECATED_STYLE)
		}
		
		return displayString
	}
	
}
