/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.Guard
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.ReactionEffect
import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.base.expressions.expressions.RegularEventSpec
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.base.expressions.expressions.TimeEventType
import com.yakindu.base.types.Effect
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Trigger
import com.yakindu.sct.model.sexec.transformation.SequenceBuilder
import com.yakindu.sct.model.sgraph.Reaction
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.AlwaysEvent
import com.yakindu.sct.model.stext.stext.EntryEvent
import com.yakindu.sct.model.stext.stext.ExitEvent
import com.yakindu.sct.model.stext.stext.StextFactory
import com.yakindu.sct.model.stext.stext.LocalReaction

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SCXMLReactiveElementGenerator {

	@Inject
	extension protected SCXMLExpressions
	@Inject
	extension protected SCXMLNameProvider
	@Inject
	extension protected SequenceBuilder

	def dispatch generateLocalReactions(Statechart it) '''
	«FOR reaction : localReactions»
		«reaction.generate»
	«ENDFOR»
	'''

	def dispatch generateLocalReactions(State it) '''
		«FOR timeEvent : it.outgoingTransitions.map[trigger].filter(ReactionTrigger).map[it.triggers].flatten.filter(TimeEventSpec)»
			<onentry>
				«timeEvent.send(timeEvent.value)»
			</onentry>
			<onexit>
				<cancel sendid="«timeEvent.fullyQualifiedName»" />
			</onexit>
		«ENDFOR»
		«FOR reaction : localReactions»
			«reaction.generate»
		«ENDFOR»
	'''
	
	def dispatch protected send(TimeEventSpec it, PrimitiveValueExpression value)'''
		<send event="«fullyQualifiedName»" delay="«value.code»«unit.literal»"/>
	'''
	
	def dispatch protected send(TimeEventSpec it, Expression value) '''
		<send event="«fullyQualifiedName»" delayexpr="«buildValueExpression(it).code»"/>
	'''
	
	

	def dispatch CharSequence generate(Reaction it) '''
		«it.trigger.generate(it)»
	'''

	def dispatch generate(Trigger it, Reaction reaction) '''No dispatch for «it» «reaction»'''

	def dispatch generate(ReactionTrigger it, Reaction reaction) '''
		«IF triggers.isNullOrEmpty»
			«generate(StextFactory.eINSTANCE.createAlwaysEvent , guard, reaction)»
		«ELSE»
			«FOR trigger : triggers»«trigger.generate(guard, reaction)»«ENDFOR»
		«ENDIF»
	'''

	def dispatch generate(RegularEventSpec it, Guard guard, Reaction reaction) '''
		<transition event ="«it?.event.code»" «guard.condAttribute» type="internal" >
			«reaction.effect?.generate»
		</transition>
	'''

	def dispatch generate(TimeEventSpec it, Guard guard, Reaction reaction) '''
		<onentry>
			«it.send(value)»
		</onentry>
		<transition event="«fullyQualifiedName»" «guard.condAttribute» «IF reaction instanceof LocalReaction»type="internal"«ENDIF»>
			«reaction.effect?.generate»
			«IF it.type == TimeEventType.EVERY»
				<send event="«fullyQualifiedName»" delay="«it.value.code»«it.unit.literal»"/>
			«ENDIF»
		</transition>
		<onexit>
			<cancel sendid="«fullyQualifiedName»" />
		</onexit>
	'''

	def dispatch generate(AlwaysEvent it, Guard guard, Reaction reaction) '''
	<transition «guard.condAttribute» type="internal" >
		«reaction.effect?.generate»
	</transition>
	'''

	def dispatch generate(EntryEvent it, Guard guard, Reaction reaction) '''
		<onentry>
			«generateReaction(guard, reaction)»
		</onentry>
	'''

	protected def condAttribute(Guard guard) {
		val cond = guard?.expression?.code?.toString
		if (cond.isNullOrEmpty) 
			return ''''''
		else
			return '''cond="«cond»"''' 
	}
	
	protected def CharSequence generateReaction(Guard guard, Reaction reaction) '''
		«IF guard !== null»
			<if cond="«guard.expression.code»">
		«ENDIF»
		«reaction.effect.generate»
		«IF guard !== null»
			</if>
		«ENDIF»
	'''

	def dispatch generate(ExitEvent it, Guard guard, Reaction reaction) {
		'''
			<onexit>
				«generateReaction(guard, reaction)»
			</onexit>
		'''
	}

	def dispatch generate(ReactionEffect it) '''
		«FOR effect : actions»
			«effect.executableContent»
		«ENDFOR»
	'''

	def dispatch generate(Effect it) {}

}
