/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 	Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.ImportScope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

/**
 * 
 * @author Markus Muehlbrandt - Initial contribution and API
 * @author Jonathan Thoene - Adding of functions to generate mocking statements
 * 
 */
class SCTUnitCNaming extends BaseNamingExtensions {

	@Inject extension INamingService
	@Inject GeneratorEntry entry
	@Inject protected Naming naming
	@Inject extension CSCTUnitGenmodelEntries
	
	def String testOperationName(SCTUnitOperation it) {
		// functions must not have the same name as the containing class.
		val tcName = it.SCTUnitClass.testClassName
		var opName = name
		if(opName != tcName && opName != statechart?.name) {
			return opName
		}
		opName = opName.toFirstLower
		if(opName != tcName && opName != statechart?.name) {
			return opName
		}
		opName += "_op"
		opName
	}
	
	def sc_timer_service() { "sc_unit_timer_service"}

	def String cc(String it) '''«it».«entry.testFilenameExtension»'''

	def String sgen(String it) {
		it + ".sgen"
	}
	
	def testClassObject() {
		"tc"
	}

	def asRaiser(EventDefinition it) {
		naming.asRaiser(it)
	}
	
	def asRaised(EventDefinition it) {
		naming.asRaised(it)
	}

	def prefix(Statechart it) {
		name.asIdentifier.toFirstLower
	}
	
	def dispatch getterName(EObject eObject) {
		// Unknown element 
	}
	
	def dispatch getterName(VariableDefinition it) {
		naming.asGetter(it)
	}
	
	def dispatch getterName(EventDefinition it) {
		naming.asRaised(it)
	}
	
	def dispatch setterName(VariableDefinition it) {
		naming.asSetter(it)
	}
	
	def dispatch setterName(Declaration it) {
		naming.asSetter(it)
	}
	
	def dispatch setterName(EventDefinition it) {
		naming.asRaiser(it)
	}
	
	def valueOfName(EventDefinition it){
		naming.asGetter(it)
	}
	
	override dispatch String valueGetter(VariableDefinition definition) {
		'''«definition.getterName»(&«statechartNaming»)'''
	}
	
	override dispatch String valueGetter(EventDefinition definition) {
		'''«naming.asGetter(definition)»(&«statechartNaming»)'''
	}
	
	def String valueOfGetter(Expression owner, EventDefinition definition) {
		'''«definition.valueOfName»(«getHandle(owner)»)'''
	}
	
	def String valueGetter(Expression owner, TypedDeclaration definition) {
		'''«definition.getterName»(«getHandle(owner)»)'''
	}
	
	def String valueSetter(Expression owner, Declaration definition) {
		'''«definition.setterName»(«getHandle(owner)»)'''
	}
	
	def String valueSetter(Expression owner, Declaration definition, CharSequence value) {
		'''«definition.setterName»(«getHandle(owner)», «value»)'''
	}
	
	def dispatch getHandle(Expression it) {
		'''/*Cannot find handle for Expression: '«it»' */'''
	}
	
	def dispatch CharSequence getHandle(FeatureCall it) {
		if (feature instanceof VariableDefinition) {
			return owner.getVarHandle(feature as VariableDefinition)
		}
		// otherwise it's a property
		return '''«owner.getHandle»'''
	}
	
	def dispatch getHandle(ElementReferenceExpression it) {
		if(reference instanceof Declaration) {
			'''«naming.asGetter(reference as Declaration)»(&«statechartNaming»)'''
		}
	}
	
	def dispatch getVarHandle(FeatureCall it, VariableDefinition variable) {
		if(owner instanceof FeatureCall) {
			return '''«naming.asGetter(variable)»(«owner.getHandle»)'''
		}
		return '''«naming.asGetter(variable)»(«getHandle»)'''
	}
		
	def dispatch getVarHandle(ElementReferenceExpression it, VariableDefinition variable) {
		if(featureOrReference instanceof VariableDefinition) {
			return '''«naming.asGetter(variable)»(«getHandle»)'''
		}
		'''«naming.asGetter(variable)»(&«statechartNaming»)'''
	}
	
	def dispatch getVarHandle(EObject it, VariableDefinition variable){
		'''«naming.asGetter(variable)»(&«statechartNaming»)'''
	}
	
	def dispatch String valueGetter(Property object) {
		'''unknown type: «object.eClass.name»'''
	}
	
	def dispatch String valueGetter(ElementReferenceExpression expression) {
		return expression.reference.valueGetter.toString
	}
	
	override dispatch valueSetter(VariableDefinition it) {
		naming.asSetter(it)
	}
	
	override dispatch CharSequence valueSetter(FeatureCall it) {
		val featureRoot = EcoreUtil2.getRootContainer(it.feature)
		if (!(featureRoot instanceof Statechart)) {
			return owner.valueSetter
		}
		feature.valueSetter
	}
	
	def dispatch operationParamStructName(Operation op, Scope sc) {
		// should never be called
	}
	
	def dispatch operationParamStructName(Operation op, ImportScope sc) {
		'''«op.name.toFirstLower»'''
	}

	def dispatch operationParamStructName(Operation op, InternalScope sc) {
		'''«op.name.toFirstLower»'''
	}

	def dispatch operationParamStructName(Operation op, InterfaceScope sc) {
		'''«IF !sc.name.nullOrEmpty»«sc.name.toFirstLower»«op.name.toFirstUpper»«ELSE»«op.name.toFirstLower»«ENDIF»'''
	}

	def operationMockClassName(Operation op) {
		if (op.getScope !== null) {
			return operationMockClassName(op, op.getScope)
		}
		return '''«op.name.toFirstUpper»Mock'''
	}

	def dispatch operationMockClassName(Operation op, Scope sc) {
		// should never be called
	}
	
	def dispatch operationMockClassName(Operation op, ImportScope sc) {
		'''«op.name.toFirstUpper»Mock'''
	}

	def dispatch operationMockClassName(Operation op, InternalScope sc) {
		'''«op.name.toFirstUpper»Mock'''
	}

	def dispatch operationMockClassName(Operation op, InterfaceScope sc) {
		'''«IF !sc.name.nullOrEmpty»«sc.name.toFirstUpper»«ENDIF»«op.name.toFirstUpper»Mock'''
	}

	def mockBehaviorName(Operation op) {
		if (op.getScope !== null) {
			return mockBehaviorName(op, op.getScope)
		} else {
			return '''«op.name.toFirstLower»Behavior'''
		}
	}

	def dispatch mockBehaviorName(Operation op, Scope sc) {
		''''''
	}
	
	def dispatch mockBehaviorName(Operation op, ImportScope sc) {
		'''«op.name.toFirstLower»Behavior'''
	}

	def dispatch mockBehaviorName(Operation op, InternalScope sc) {
		'''«op.name.toFirstLower»Behavior'''
	}

	def dispatch mockBehaviorName(Operation op, InterfaceScope sc) {
		'''«IF !sc.name.nullOrEmpty»«sc.name.toFirstLower»«op.name.toFirstUpper»Behavior«ELSE»«op.name.toFirstLower»Behavior«ENDIF»'''
	}

	def operationMockObjectName(Operation op) {
		'''«operationMockClassName(op).toString.toFirstLower»'''
	}

	def setOperationBehaviorName(Operation op) {
		'''set«mockBehaviorName(op).toString.toFirstUpper»'''
	}

	def CharSequence statechartNaming() {
		'''statechart'''
	}
	
	def variableAccess(VariableDefinition it){
		'''«statechartNaming».«naming.instance(it.scope)».«name.asEscapedIdentifier»'''
	}
}
