/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.csharp.codepattern.ClassCode
import com.itemis.create.base.generator.csharp.codepattern.MethodCode
import com.itemis.create.base.generator.csharp.codepattern.VariableCode
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.Part
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.annotations.VisibilityAnnotations
import java.util.List
import com.yakindu.base.types.ComplexType
import org.eclipse.emf.ecore.EObject

/**
 * Defines the code model concept of a C# class. The provided builder methods create 
 * code model elements which are preconfigured for using the default C# code generator templates. 
 * 
 * @author Axel Terfloth
 */
@Singleton
class CsharpClass {

	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension ClassCode
	@Inject protected extension MethodCode
	@Inject protected extension VariableCode
	@Inject protected extension VisibilityAnnotations

	public static String CLASS_ANNOTATION = "__class__"
	public static String INTERFACE_ANNOTATION = "__interface__"
	public static List<String> SIGNATURE_ANNOTATIONS = #[CLASS_ANNOTATION, INTERFACE_ANNOTATION]

	def _csharpClass(String name) {

		_public(_complexType(name)) => [
			_csharpClass
		]
	}

	def _csharpClass(ComplexType it) {

		_annotate(CLASS_ANNOTATION)
		generateDefinitionWith[classCode]
	}

	def _csharpInterface(String name) {

		_public(_complexType(name)) => [
			_csharpInterface
		]
	}

	def _csharpInterface(ComplexType it) {
		_annotate(INTERFACE_ANNOTATION)
		generateDefinitionWith[classCode]
	}
	
	def isCsharpInterface(EObject it){
		if(it instanceof AnnotatableElement){
			if(getAnnotationOfType(INTERFACE_ANNOTATION) !== null) 
				return true
		} 
		return false
	}

	def signature(AnnotatableElement it) {
		for (a : SIGNATURE_ANNOTATIONS) {
			if(getAnnotationOfType(a) !== null) return a.replaceAll("_", "")
		}
	}

	def _csharpMethod(String name, TypeSpecifier returnType) {

		_op(name, returnType) => [
			generateDefinitionWith[methodDefinitionCode]
			implementation = _block()
		]

	}

	def _csharpVariable(Property v) {
		_variable(v.name, v.type) => [
			annotations += v.annotations
			initialValue = v.initialValue
			generateDefinitionWith[variableDeclarationCode]
		]
	}

	def _csharpVariable(Part v) {
		_part(v.name, v.type) => [
			annotations += v.annotations
			generateDefinitionWith[variableDeclarationCode]
		]
	}

}
