/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.csharp.codepattern.NamespaceCode
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypeBuilder

/**
 * Defines the code model concept of a C# name space. A name space contains one or more declarations which are member of that name space. 
 * A name space model element is a Package which is annotated as name space. 
 * This concept definition provides a builder to create a properly defined C# name space including generator assignment
 * and a query to check if a package element represents a compilation unit. 
 * 
 * @author Axel Terfloth
 */
class CsharpNamespace {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension NamespaceCode
	
	public static final String CSHARP_NAMESPACE = "__csharp_namespace__"
	
	def _csNamespace() {
		_package => [
			it._csNamespace
		]
	}
	
	def _csNamespace(Package it) {
		_annotate(CSHARP_NAMESPACE)
		generateDefinitionWith[namespaceCode]
	}
	
	def isCsNamespace(Package it) {
		getAnnotationOfType(CSHARP_NAMESPACE) !== null
	}
	
	
}