/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.IEnumCode
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.yakindu.base.types.EnumerationType

/**
 * The implementation pattern for enum classes. 
 * 
 * @author laszlo kovacs - Initial contribution.
 */
class EnumCode implements IEnumCode {
	
	@Inject protected extension CsharpVisibility
	
	override enumerationCode(EnumerationType it) '''		
		«csharpVisibility» enum «it.name»
		{
			«FOR e : it.enumerator SEPARATOR ","»
				«e.name»
			«ENDFOR»
		};
	'''	
}
