/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.concepts.TimedInterface
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpCompilationUnit
import com.itemis.create.base.generator.csharp.codemodel.CsharpNamespace
import com.itemis.create.base.generator.csharp.codemodel.CsharpStatemachineLibrary
import com.itemis.create.base.generator.csharp.codepattern.ClassCode
import com.itemis.create.base.generator.csharp.transformation.EventBufferTransformation
import com.yakindu.base.types.Package
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.codemodel.StateMetaInformation
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.codemodel.StatemachineFunctions
import com.yakindu.sct.generator.core.codemodel.StatemachineProperties
import com.yakindu.sct.generator.core.extensions.ICodeModel
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import org.eclipse.xtext.EcoreUtil2

/**
 * The code model is created from the executution flow and consist of type system based model elements.
 * These model elements represent concrete C++ implementation artifacts which represent different implementation
 * concepts 
 * 
 * @author axel terfloth
 * @author laszlo kovacs
 *
 */
@Singleton class CsharpStatemachineCodeModel implements ICodeModel{

	@Inject protected extension StateEnum
	@Inject protected extension StatemachineProperties
	@Inject protected extension CsharpStatemachineMembers
	@Inject protected extension CsharpStatemachineOperationCallbacks
	@Inject protected extension CsharpStatemachineEvents
	@Inject protected extension StateMetaInformation
	@Inject protected extension SExecExtensions
	@Inject protected extension CsharpStatemachineConstructor

	@Inject protected extension StatemachineClass
	@Inject protected extension CsharpNamedInterfaceClasses
	@Inject protected extension StatemachineFunctions
	@Inject protected extension EventBufferTransformation
	@Inject protected extension CsharpEventQueueImplementation
	@Inject protected extension CsharpInternalFunctions
	
	@Inject protected extension CsharpStatemachineLibrary
	@Inject protected extension Statechart2TypeTransformation
	
	@Inject protected extension CsharpCompilationUnit
	@Inject protected extension CsharpNamespace
	@Inject protected extension CsharpClass
	
	@Inject protected extension GeneratorAssignment
	@Inject protected extension ClassCode
	@Inject protected extension Documentation
	@Inject protected extension OriginTracing
	
	@Inject protected extension TimedInterface
	
	@Inject protected extension EventQueue
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	

	def create cu : _compilationUnit implementationClassCompilationUnit(ExecutionFlow it) {
		
		val implClass = implementationClass
		
		cu.name = implClass.name
		
		val topLevelNamespace = EcoreUtil2.getAllContainers(implClass).filter(Package).findLast[isCsNamespace]
		
		if (topLevelNamespace !== null) {
			cu.member += topLevelNamespace
		} else {
			cu.member += implClass
		}
	}
	
	override defineImplementationClass(ExecutionFlow it) {
		it.implementationClass
	}
	
	
	def create i : flow.stateMachineClass implementationClass(ExecutionFlow flow) {
		
		i.documentation('''Class of the state machine '«i.name»'.''')
		
		i._csharpClass
		
		i.traceOrigin(flow.statechart)
		
		EcoreUtil2.getAllContainers(i).filter(Package).forEach[ it._csNamespace ]
		
		flow.statechart.createTypeDescription
		
		val statechartTypeDescription = flow.statechart.statechartType
		
		i.superTypes += createTypeSpecifier => [
			
			type = statechartTypeDescription.superTypes.head.type.asCsharpDeclaration as Type
		]
		
		if(flow.timed){
			createTimedInterface
			i.superTypes += createTypeSpecifier => [
				type = timedType
			]
		}
		
		flow.namedInterfaceClasses
				
		flow.operationCallback(i)
		
		flow.defineStateEnum(i)
		
		flow.defineEvents
		
		flow.defineMembers
		
		flow.defineProperties		
		 
		flow.defineStateMetaInformation
		
		flow.defineFunctions
		
		if (flow.requiresEventQueue) {
			flow.defineEventQueueImplementation
		}
		
		flow.transformEventBuffer
		
		flow.copyNamedIfaceFunctionDeclarations
		
		i.defineConstructor

		i.generateDefinitionWith[ '''
			«i.classDeclaration» {
				«FOR f : i.features»
					
					«f.declarationCode»
				«ENDFOR»
				«FOR f : i.features»
					
					«f.definitionCode»
				«ENDFOR»
				«flow.functionImplementations»
			}

		''' ]
	}
	
	
}
