/**
 * Copyright (c) 2022-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.types

import com.yakindu.base.expressions.interpreter.base.IInstanceFactory
import com.yakindu.base.expressions.interpreter.base.IInterpreter
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Package
import com.yakindu.sct.model.sruntime.CompositeSlot

import static extension org.eclipse.xtext.EcoreUtil2.*

/**
 * 
 * @author axel terfloth
 */
class ComplexTypeInstance extends RuntimeInstance {
	
	protected ComplexType declarator
	
	def void setUp(CompositeSlot instance, ComplexType declarator, IInterpreter.Context context, IInstanceFactory factory) {
		super.setUp(instance, context, factory)		
		this.declarator = declarator 
	}
		
	override declarationPackage() { declarator.getContainerOfType(Package) }
	
	override declarations() { declarator.allFeatures }	
	 
}
