/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SexecBuilder

/**
 * This class defines the general concept of checking the initialization state of a state machine.
 * 
 * @author Thomas Kutz
 */
class InitializedCheck {
	
	@Inject extension SexecBuilder
	
	public static val INIT_CHECK = StateMachineBehaviorConcept.CONCEPT_NAME_PREFIX + "isInitializedCheck"
		
	def Step _isInitializedCheck(ExecutionFlow it) {
		_conceptSequence(com.yakindu.sct.model.sexec.concepts.InitializedCheck.INIT_CHECK)
	}
}