/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.SexecBuilder
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * This class defines the general concept of the runCycle method which implements 
 * the run to comlpetion step (RTCS) of a state machine. 
 * 
 * @author aterfloth
 */
@Singleton
class RunCycleMethod {

	@Inject protected extension ExecutionGuard
	@Inject protected extension EventProcessing
	@Inject protected extension SuperStep superStep
	@Inject protected extension MicroStep
	@Inject protected extension InitializedCheck
	@Inject protected extension CompletionEvent

	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension SexecBuilder
	@Inject protected extension StatechartAnnotations

	@Inject protected extension SExecExtensions

	public static val RUN_CYCLE = "runCycle";

	def defineFeatures(ExecutionFlow it) {
		defineRunCycle
	}

	def defineRunCycle(ExecutionFlow it) {

		it._method(RUN_CYCLE) => [ m |
			if(needsRunCycleFunctionAsAPI) {
				m._public
			}
			m._type(_void)
			m._body(
				_isInitializedCheck,
				_guardExecution(_sequence(
					_traceBeginRunCycle,
					_eventProcessing(
						_superStepLoop(
							if(microStep.exists) microStep._call.toStep else _empty
						)
					),
					_traceEndRunCycle
				))
			)
			m.body.comment = "Performs a 'run to completion' step."
		]
	}

	def Method runCycle(ExecutionFlow it) {
		features.filter(typeof(Method)).filter(m|m.name == RUN_CYCLE).head
	}
	
	def dispatch boolean needsRunCycleFunctionAsAPI(ExecutionFlow it){
		(sourceElement as Statechart).needsRunCycleFunctionAsAPI
	}
	
	def dispatch boolean needsRunCycleFunctionAsAPI(Statechart it){
		it.isCycleBased
	}
	
	def dispatch hasRunCycleFunctionAsAPI(ExecutionFlow it){
		needsRunCycleFunctionAsAPI
	}
	
	def dispatch hasRunCycleFunctionAsAPI(Statechart it){
		needsRunCycleFunctionAsAPI
	}
}
