/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.simulation.core.sexec.interpreter

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.interpreter.base.IInterpreter.Instance
import com.yakindu.base.expressions.interpreter.context.IExecutionContextInitializer
import com.yakindu.base.expressions.interpreter.types.RuntimeInstanceFactory
import com.yakindu.base.types.inferrer.ITypeSystemInferrer.InferenceResult
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sruntime.ExecutionContext

/**
 * Creates statechart instances based on an ExecutionFlow
 * 
 * @author Axel Terfloth (terfloth@itemis.de)
 */
@Singleton
class SexecInstanceFactory extends RuntimeInstanceFactory {
	
	@Inject protected extension StatemachineTypes
	@Inject protected IExecutionContextInitializer contextInitializer


	protected def dispatch Object createNewInstance(ExecutionFlow flow) {
		val instance = createExecutionContext => [
			name = if (heap.slots.size == 0) "$root" else "instance@" + heap.slots.size
			fqName = name
			type = flow
		]
		
		contextInitializer.initialize(instance, flow)
		flow.createInstanceMembers(instance)
		
		heap.slots.add(instance)
		
		instance.adaptInstance( createInstanceExecution(instance, flow) )

		instance
	}
	
	
	def protected Instance createInstanceExecution(ExecutionContext instanceMemory, ExecutionFlow flow) {
		new ExecutionFlowInstance => [
			it.injectMembers
			it.setUp(instanceMemory, instanceContext, flow)	
		]
	} 
	
	
	protected def dispatch Object createNewInstance(ExecutionFlow flow, InferenceResult ts) {
		flow.createNewInstance
	}
	
}