/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.qt.codemodel

import com.yakindu.base.types.Event
import com.yakindu.sct.generator.cpp11.codemodel.EventAccessors
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.google.inject.Inject
import org.eclipse.emf.ecore.util.EcoreUtil

/**
 * Definition of event accessor methods for Qt. 
 * 
 * @author axel terfloth - Initial contribution.
 * 
 */
class QtEventAccessors extends EventAccessors {
	
	@Inject protected extension QtCodeModelBuilder
		
	override protected void defineOutEventAccessors(EventDefinition e) {
		super.defineOutEventAccessors(e)
		e.defineSignal
	}
	
	def protected defineSignal(EventDefinition e) {
		val method =  _op(e.signalSlotName.toString, _void ) => [
			documentation('''Signal representing the out event '«e.name»' that is defined in the «e.scope.scopeDescription».''')		
			_public 
			_signal

			if (e.hasValue) {
				_param("value", EcoreUtil.copy(e.typeSpecifier))
			}

			generateDeclarationWith[ methodDeclarationCode ]
		]

		// add all signals to state machine class instead of scope class
		e.flow.stateMachineClass.features += method
		return method
	}
	
		
	override protected defineInEventAccessors(EventDefinition e) {
		super.defineInEventAccessors(e) => [ 
			_slot
			documentation('''Slot for the in event '«e.name»' that is defined in the «e.scope.scopeDescription».''')

			// add all slots to state machine class instead of scope class
			e.flow.stateMachineClass.features += it
		]		
	}
	
	override protected activateEventCode(EventDefinition e) '''
		«IF e.hasValue»
			«IF e.scope.isNamedScope»«e.scope.instance».«ENDIF»«e.localValueAccess» = «e.asParameter»;
		«ENDIF»
		«IF e.scope.isNamedScope»«e.scope.instance».«ENDIF»«e.localAccess» = true;
	'''
	
	override asRaiser(EventDefinition it) {
		signalSlotName
	}
	
	def signalSlotName(Event e) {
		
		val scope = e.scope
		val scope_prefix = if (scope instanceof InterfaceScope) 
							if (scope.name !== null) scope.simpleName.asIdentifier + "_"
								else ""
							else "" 

		return scope_prefix + e.name.asIdentifier
	}
	
	
}