/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.extensions

import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.InterfaceScope

/**
 * @author rbeckmann
 *
 */
class CShortNaming extends Naming {
	override stateName(ExecutionState it) {
		getContainerType + separator + provider.getFullyQualifiedName(it).lastSegment
	}
	
	override stateName(RegularState it) {
		getContainerType + separator + provider.getFullyQualifiedName(it).lastSegment
	}
	
	override dispatch String type(InterfaceScope it) {
		if(name.nullOrEmpty) {
			getContainerType + 'Iface'
		} else {
			getContainerType + 'I' + separator + name.asIdentifier.toFirstUpper
		}
	}
	
	override protected entryStatemachinePrefix(Statechart it) {
		null
	}
	
	override protected entryStatemachinePrefix(ExecutionFlow it) {
		null
	}
	
}