/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules.eventdriven

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Direction
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.submodules.EventCode
import com.yakindu.sct.generator.core.templates.ExpressionsGenerator
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.stext.stext.EventDefinition

/**
 * @author rbeckmann
 * @author axel terfloth
 *
 */
@Singleton // Guice
class EventDrivenEventCode extends EventCode {
	@Inject protected extension EventQueue

	@Inject extension EventNaming
	@Inject protected extension Literals
	@Inject protected extension ExpressionExtensions
	
	protected static int valueVarIndex = 0
	
	override CharSequence eventRaisingCode(EventRaisingExpression it, ExpressionsGenerator exp) {
		if (event.featureOrReference.eContainer instanceof ComplexType) {
			val fc = event as FeatureCall
			return '''«(fc.feature as EventDefinition).asRaiser»(«fc.owner.getHandle»«IF value !== null», «exp.code(value)»«ENDIF»)'''
		}
		if(eventDefinition.isQueued){
			return '''«toQueue(exp)»'''
		}
		return '''
		«super.eventRaisingCode(it, exp)»«IF eventDefinition.direction !== Direction.OUT»;
		«runCycleFctID(flow)»(handle)«ENDIF»'''
	}
	
	protected override raiseLocalOutEvent(EventRaisingExpression it, ExpressionsGenerator exp) {
		val localOutEvent = event.definition.event.getLocalOutEvent()
		'''
		«IF value !== null»
			{
				«localOutEvent.valueDeclaration» = «exp.code(value)»;
				«flow.addToQueueValueFctID»(&(«scHandle»->«internalQueue»), «localOutEvent.eventEnumMemberName», &«localOutEvent.valueName»);
			}
		«ELSE»
			«flow.addToQueueFctID»(&(«scHandle»->«internalQueue»), «localOutEvent.eventEnumMemberName»)«ENDIF»'''
	}
	
	override interfaceIncomingEventRaiserBody(ExecutionFlow it, EventDefinition event)  {
		if(event.isQueued) {
			'''
			«IF event.hasValue»
			«flow.addToQueueValueFctID»(&(«scHandle»->«inEventQueue»), «event.eventEnumMemberName», &value);
			«ELSE»
			«flow.addToQueueFctID»(&(«scHandle»->«inEventQueue»), «event.eventEnumMemberName»);
			«ENDIF»
			«runCycleFctID»(«scHandle»);
			'''
		} else {
			'''
			«IF event.hasValue»
			«event.valueAccess» = value;
			«ENDIF»
			«event.access» = «TRUE_LITERAL»;
			
			«runCycleFctID»(«scHandle»);
			'''
		}
	}
	
	
	
	def toQueue(EventRaisingExpression it, ExpressionsGenerator exp) {
		val valueVarName = '''value_«valueVarIndex++»'''
		val event = event.definition.event
		val queue = '''&(«scHandle»->«switch(event.direction) {
			case IN: inEventQueue
			case LOCAL: internalQueue
			case OUT: ""
		}»)'''
		'''
		«IF value !== null»
		{
			«event.typeSpecifier.targetLanguageName» «valueVarName» = «exp.code(value)»;
			«flow.addToQueueValueFctID»(«queue», «event.eventEnumMemberName», &«valueVarName»);
		}
		«ELSE»
		«flow.addToQueueFctID»(«queue», «event.eventEnumMemberName»)«ENDIF»'''
	}
	
	def eventDefinition(EventRaisingExpression it) {
		val decl = event.definition
		if(decl instanceof EventDefinition) {
			decl
		} else null
	}
	
	
	override eventNextCode(ExecutionFlow it) '''
		«dispatchNextEventFctID»(«scHandle»);
	'''
	
	
}