/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.generator.java.submodules.lifecycle.InitSequence
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.InterfaceScope

@Singleton
class StatemachineFunctionsGenerator {
	
	@Inject extension Naming
	@Inject extension SExecExtensions
	@Inject extension GenmodelEntries
	@Inject extension Synchronized
	@Inject extension InitSequence
	@Inject extension EventCode
	@Inject extension VariableCode
	@Inject extension OperationCallbackCode
	@Inject extension InterfaceFunctionsGenerator
	
	def createConstructor(ExecutionFlow flow, GeneratorEntry entry) '''
		public «flow.statemachineClassName»() {
			«FOR scope : flow.namedInterfaceScopes»
			«scope.interfaceVariableName» = new «scope.interfaceTypeName»(«IF scope.needsStatemachineReference(entry)»this«ENDIF»);
			«ENDFOR»
			«flow.initializationSequence»
		}

	'''
	
	def defaultInterfaceFunctions(ExecutionFlow flow, GeneratorEntry entry) '''
		«val InterfaceScope scope = flow.defaultScope»
		«IF scope !== null»
			«IF scope.hasOperations»
				«scope.generateOperationCallback»
				
			«ENDIF»
			«FOR event : scope.eventDefinitions»
				«generateEventDefinition(event, entry, scope)»
				
			«ENDFOR»
			«FOR variable : scope.variableDefinitions»
				«variable.code»
				
			«ENDFOR»
		«ENDIF»
	'''
	
	def interfaceAccessors(ExecutionFlow flow, GeneratorEntry entry) '''
		«FOR scope : flow.namedInterfaceScopes»
			public «scope.interfaceTypeName» «scope.interfaceGetterName» {
				return «scope.interfaceVariableName»;
			}

		«ENDFOR»
		«IF tracingUsed(entry)»
			«generateTraceAccessors(entry)»
		«ENDIF»
		«IF tracingGeneric(entry)»
			public Observable<«traceEventClass»<«flow.statemachineClassName», State, Feature>> getTrace() {
				return trace;
			}
		«ENDIF»
		
	'''
	
	def protected generateTraceAccessors(GeneratorEntry entry) '''
		public «sync»void add«traceAccessorFunctionID.toFirstUpper»(«tracingListener»<State> «traceSingleInstance») {
			if(!(this.«traceInstances».contains(«traceSingleInstance»))) {
				this.«traceInstances».add(«traceSingleInstance»);
			}
		}
		
		public «sync»void remove«traceAccessorFunctionID.toFirstUpper»(«tracingListener»<State> «traceSingleInstance») {
			if(this.«traceInstances».contains(«traceSingleInstance»)) {
				this.«traceInstances».remove(«traceSingleInstance»);
			}
		}
	'''
}