/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.xformation.lmx.LmxException;
import com.yakindu.licmgmt.LicenseException;
import java.util.regex.Pattern;

public final class LicenseExceptionHelper {
    static final String GROUP_FEATURE_ID = "FeatureId";
    static final Pattern LICENSE_VERSION_PATTERN = Pattern.compile("\\d+\\.\\d+");
    static final Pattern LICENSE_FEATURE_ID_PATTERN = Pattern.compile("(?<FeatureId>[\\w\\-]+)");

    public static void throwLicenseException(String message) throws LicenseException {
        if (message == null || message.isEmpty()) {
            throw new IllegalArgumentException("message cannot be null or empty.");
        }
        throw new LicenseException(message);
    }

    public static void throwLicenseException(String message, LmxException exceptionToLog) throws LicenseException {
        if (exceptionToLog == null || message == null || message.isEmpty()) {
            throw new IllegalArgumentException("See javadoc of this method for what is allowed.");
        }
        throw new LicenseException(message);
    }

    public static void throwLicenseException(String prefix, String featureId, LmxException lmxException) throws LicenseException {
        if (featureId == null || lmxException == null || prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("See javadoc of this method for what is allowed.");
        }
        LicenseExceptionHelper.throwLicenseException(String.valueOf(prefix) + " " + lmxException.getErrorStr());
    }

    public static void verifyFeatureId(String featureId) {
        if (featureId == null || featureId.length() == 0 || featureId.length() >= 64 || !LICENSE_FEATURE_ID_PATTERN.matcher(featureId).matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Feature name according to https://docs.x-formation.com/display/LMX/FEATURE+settings ", featureId));
        }
    }

    public static void verifyFeatureVersion(String featureVersion) {
        if (featureVersion == null || featureVersion.trim().isEmpty() || !LICENSE_VERSION_PATTERN.matcher(featureVersion).matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a correct feature version. It should be <major number>.<minor number>.", featureVersion));
        }
    }
}

